*****************************************************************************
**                                                                         **
** Engine: 8 Bit Amplifier                                                **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 

; umgebaut auf neue AS_Struktur am 19.07.96
; 2.8.: Iconify Flag bei "Show" ausgetestet
; 6./7.8. - fix fr Check, ob noch 8 Bytes zu mixen sind, addx eingebaut
;         - Untersttzung von EPAMF_WaitForStruct
; 23.4.98 - Rckkopieren der AS Struktur wegen Scopes
; xx.5.98 - UnlockPubscreen fix
	;
	;
	incdir	include:
	include	exec/exec_lib.i
	include	exec/execbase.i
	include	exec/libraries.i
	include	exec/lists.i
	include	exec/memory.i
	include	exec/types.i
 	include	intuition/intuition.i
	include	intuition/intuition_LIB.i
	include	graphics/graphics_lib.i
	include	libraries/gadtools.i
	include	libraries/gadtools_lib.i
	include	dos/dos_lib.i
	include	libraries/dos.i
	include	misc/eagleplayer.i
	include	misc/eagleplayerengine.i
	include	misc/BuggsMacros.i

	;
	section	0,code_p
	;
ver		macro
		dc.b	"0.96"
		endm
StructVer	macro
		dc.w	0,96
		endm
date		macro
		dc.b	"20-May-98"
		endm
StructDate	macro
		dc.b	20,05
		dc.w	1998
		endm

userprogram	=	1
debug	 	=	0
test		=	0		;topaz nehmen ?
SamLEN		=	224
Benchmark	=	0	;Benchmark = 1 => Vergleich zwischen alter wortweiser und neuer 
				;                 langwortweiser CopyBuffer Routine
BenchMark2	=	0
V37Gadtools	=	0	;Test fr Kick2.0 Kompatibilitt durch Gadtools13.library

NumChipBuffers	=	4	;Anzahl der Puffer im Chipram (wg. FFT Analyzer)
;----------------------- Noteplayer-spezifische Infos --------------------

Project0Width = 309		;Windowbreite (default bei Topaz 8)
Project0Height = 158
Project0Left = 41
Project0Top = 45
ZoomWidth = 200

GD_LISTVIEW                            EQU    0
GD_Samplefreq                          EQU    1
GD_MixingSlider                        EQU    2
GD_VBoost                              EQU    3
GD_Voices                              EQU    4
GD_NumVBoost                           EQU    5
GD_Playmode                            EQU    6
GD_Surlevel                            EQU    7

Project0_CNT    EQU    8


 structure	my_liststruct,0
	struct	ML_Node,ln_size
	struct	ML_Nodename,40
	Label	ML_Sizeof

ASLoopF_BackLooping	EQU	0
ASLoopF_Looping		EQU	1
ASLoopB_BackLooping	EQU	1<<ASLoopF_BackLooping
ASLoopB_Looping		EQU	1<<ASLoopF_Looping


;------------------------------------------------------------------------
begin
****************** Workbench Startup **********************************
	bra.w	fang
	EUSN_Identifier
	dc.l	0		;eus_next

	ifne	debug
	dc.w	-2
	else
	dc.w	0		;eus_Usernr
	endc
MyEPBase
	dc.l	0		;eus_EPBase
	dc.l	0		;eus_Freetable
	dc.l	0		;eus_Taskadr
	dc.l	0		;eus_unused1
	dc.l	0		;eus_unused2
	dc.l	SpecialJumps	;EUS_SpecialJumpTab
	dc.l	TagListe	;EUS_TagList
	dc.w	0		;eus_ticks
	dc.w	0		;eus_tickcounter
	dc.l	0		;eus_tickflags
	dc.l	USMB_Configuration!USMB_KillModule!USMB_Zipwin!USMB_ChangeConfig;eus_msgflags
	dc.l	MyAnalyzername	;eus_PName
	dc.l	myBuggsname
	dc.l	myinfo
	dc.w	37		;eus_Kickstart
	dc.l	Eagleversion	;eus_EPVersion
	StructVer		;eus_version,revision
	dc.l	MyUsername	;eus_username
	dc.w	Project0left	;eus_winx
	dc.w	Project0top	;eus_winy
	dc.w	EUSB_openwin	;window opened
	dc.w	1		;pri
	dc.w	0		;flags

	dc.w	0,0		;EUS_Special2
	dc.b	0,$10,0,0	;EUS_Special3

ZoomPosX	equ	EUS_Special2
ZoomPosY	equ	EUS_Special2+2
ZoomState	equ	EUS_Special3	;Zoom or not zoom
OnMonoMode	equ	EUS_Special3+1	;Mono Modules Mode (untersch. Delay)

	StructDate		;EUS_Creatordate
	dc.b	0		;EUS_Priority

	dc.b	EUTY_Amplifier	;EUS_Type

	dc.w	0		;EUS_Reserved2
	dc.l	`8BIT`		;EUS_Reserved3;EUS_AMIDNr
	dc.l	0		;EUS_Reserved4
	dc.l	MyUPSStruct	;EUS_Reserved5
	dc.l	0		;EUS_Reserved6

TagListe:
	dc.l	EUT_EPSubItems,EP_Menu
	dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_8BitAmplifier
	dc.l	TAG_Done


	dc.b	`$VER: Eagleplayer 8 Bit 32 Voices Amplifier `
	ver
	dc.b	` `
	date
	dc.b	0
	even
SpecialJumps
	dc.l	0	;AMJ_CheckFeatures
	dc.l	Init	;AMJ_Init	;bergabe der Struktur/test&Init
	dc.l	StartInt;AMJ_StartInt	;Alloc Audio & Start Int
	dc.l	Stopint	;AMJ_StopInt	;Free Audio & Stop Int
	dc.l	End	;AMJ_End		;Mem freigeben, etc.

	dc.l	Copy_AS			;AMJ_Amplifier	;Einsprung, wenn neu gefllte Amplifier-Struktur
					;vom Replayer bergeben wurde (meist nach DTP_Interrupt-
					;Abarbeitung)
	dc.l	0	;AMJ_PokeAdr	;nur fr Noteplayer initialisieren,
	dc.l	0	;AMJ_PokeLen	;die auf die Hardware poken, wie
	dc.l	0	;AMJ_PokePer	;z.B. der Chipram Player, sonst
	dc.l	0	;AMJ_PokeVol	;auf 0 setzen, diese Jumps werden mit
	dc.l	0	;AMJ_DMAMask	;den selben Parametern aufgerufen, wie
					;die ENPP_Poke...
	dc.l	0	;AMJ_Command	;z.B. Filter
Fang
	move.l	4.w,a6

	ifeq	V37Gadtools
	cmp.w	#39,lib_version(a6)
	bge.s	.do39
	endc

	subq	#6,NG_Listview+6
.do39

	move.l	ex_EClockFrequency(a6),d0
	move.l	d0,d1
	add.l	d0,d0
	add.l	d0,d0
	add.l	d1,d0
	move.l	d0,Audiorate

	lea	datas,a5
	move.l	a5,a0
	move.w	#dataslen-1,d0
.clr	move.b	#0,(a0)+
	dbf	d0,.clr

	move	#-1,LastBoost

	move.w	attnflags(A6),d0
	and.w	#AFF_68030,d0
	move	d0,MC68030on(A5)	;wenn 030, dann UPS ins FastRam
;	clr	MC68030on(a5)

	move	#-1,Currentnumvoc(a5)		;kein Modul am Spielen

	bsr	Makedefaults			;Default prefs setzen
	bsr	Loadconfig

	st	onsysfont(A5)

	moveq	#-1,d0
	jsr	_LVOallocsignal(a6)	;Signal allokieren
	move.l	d0,mysignal(a5)
	blt	NoSignal

	suba.l	A1,A1
	JSR	_LVOfindtask(A6)
	move.l	d0,mytask(a5)

	lea	dos(pc),a1
	moveq	#37,d0			;Brauchen DOS V1.2,fr Message,falls
	jsr	_LVOopenlibrary(a6)	;Start von 1.2/1.3 aus
	move.l	d0,_dos(a5)
	beq	NODOS

	lea	MsgPort1(a5),a4		;MSG Port Struktur initialisieren
	bsr	MakeMsgPort
	tst.l	d0
	blt	NoPort
	move.l	a4,MsgPort(A5)

	lea	int(pc),a1
	moveq	#37,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,intsave(a5)
	beq	NOINT

	lea	graf(pc),a1
	moveq	#37,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,grafsave(a5)
	beq	NOGraf

	lea	gad(pc),a1

	ifeq	V37Gadtools
	moveq	#37,d0
	else
	moveq	#34,d0
	endc

	jsr	_LVOopenlibrary(a6)
	move.l	d0,gadsave(a5)
	beq	NoGadTo

	moveq	#0,d7

	bsr	sendfirstmessage	;Message an Eagleplayer senden,da
					;der Analyzer gern mal die Struktur-
					;Adresse haben mchte
	blt	endme	;Fehler aufgetreten

	bsr	HandleActions		;Auf Usereingaben reagieren

	tst.l	d7
	blt.s	endme
	bsr	sendlastmessage
endme
	bsr	closedownwin
	bsr	closedownscreen
nopubscreen
Nogadgets
nowin
	move.l	gadsave(a5),a1
	move.l	4,a6
	jsr	_LVOcloselibrary(A6)
	clr.l	gadsave(A5)
nogadto
	move.l	grafsave(a5),a1
	move.l	4,a6
	jsr	_LVOcloselibrary(a6)
NoGraf
	move.l	intsave(a5),a1
	move.l	4,a6
	jsr	_LVOcloselibrary(a6)
noint
	move.l	4,a6
	lea	msgport1(a5),a2
	move.b	mp_sigbit(a2),d0
	ext.w	d0
	ext.l	d0
	jsr	_LVOfreesignal(a6)
NoPort
	move.l	4,a6
	move.l	_dos(a5),a1
	jsr	_LVOcloselibrary(a6)
nodos
Endprog
	move.l	mysignal(a5),d0
	move.l	4,a6
	jsr	_LVOfreesignal(a6)
NoSignal
	moveq	#0,d0
	rts

MakeMsgPort
					;Message Port initialisieren
	move.l	4.w,a6
	moveq	#-1,d0
	jsr	_LVOallocsignal(a6)	;MSG Signal zuweisen lassen
	tst.l	d0
	blt	.nosignal2		;Fehler

	move.b	#nt_msgport,ln_type(a4)
	move.b	#0,ln_pri(a4)
	move.b	#pa_signal,mp_flags(a4)
	move.b	d0,mp_sigbit(a4)

	move.l	mytask(a5),mp_sigtask(a4);mp_SigTask

	lea	mp_msglist(a4),a1
	Newlist	a1			;macro in Lists.i

	moveq	#0,d0
.nosignal2				;Fehler
	rts
********************************************************************
*                  Init & Open Window                              *
********************************************************************
Openwin:
	tst.l	winhandle(A5)
	bne.w	.endme

	clr.l	port(A5)

	move.l	intsave(a5),a6
	bsr	Setupscreen		;Public Screen holen
	bne	.Endme
	bsr	SetUpWin		;Fenster ffnen
	tst.l	d0
	bne	.Endme

	bsr	drawbevel

	move.l	Winhandle(a5),a0
	move.l	wd_userport(a0),a0	;User Port
	move.l	a0,port(a5)
.endme
rtsA
	rts
DrawBevel
	move.l	gadsave(A5),a6
	move.l	winhandle(A5),a0
	move.w	wd_height(a0),d0
	cmp	offy(a5),d0
	beq.s	rtsA
	move.l  wd_RPort(a0),a2
	lea.l   IR(pc),a1
	move.l  Vi(a5),4(a1)

	move.w  #116,d0
	bsr	ComputeY
	move.w  offy(a5),d1
	add.w	d0,d1

	move.w	#300,d0
	bsr	ComputeX
	move.w	d0,d2

	move.w	#38,d0
	bsr	ComputeY
	move.w	d0,d3

	move.w  #4,d0
	bsr	ComputeX
	add.w   offx(A5),d0

	move.l  a2,a0
	jsr     _LVODrawBevelBoxA(a6)

	move.l	winhandle(A5),a0
	move.l  wd_RPort(a0),a2
	lea.l   IR(pc),a1

	move.w  #58,d0
	bsr	ComputeY
	move.w  offy(a5),d1
	add.w	d0,d1

	move.w	#300,d0
	bsr	ComputeX
	move.w	d0,d2

	move.w	#57,d0
	bsr	ComputeY
	move.w	d0,d3

	move.w  #4,d0
	bsr	ComputeX
	add.w   offx(A5),d0

	move.l  a2,a0
	jmp     _LVODrawBevelBoxA(a6)
ClearWin:
	move.l	winhandle(A5),a1
	move.w	wd_height(a1),d0
	cmp	offy(a5),d0
	beq.w	rtsA

	move.l	grafsave(a5),a6
	move.l	wd_rport(a1),a1
	moveq	#0,d0
	jsr	_LVOsetapen(A6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#0,d0
	jsr	_LVOsetbpen(A6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#1,d0			;RP_Jam2
	jsr	_LVOsetdrmd(A6)

	move.b	rp_areaptsz(a1),d4
	move.l	rp_areaptrn(a1),d5

	move.l	winhandle(A5),a1
	move.w	wd_width(A1),d2		;x2
	moveq	#0,d0
	move.b	wd_borderright(a1),d0
	sub.w	d0,d2

	move.w	wd_height(a1),d3
	moveq	#0,d0
	move.b	wd_borderbottom(a1),d0
	sub.w	d0,d3

	move.l	wd_rport(a1),a1

	move.w	offx(a5),d0		;x1
	move.w	offy(A5),d1		;y1
	jsr	_LVOrectfill(a6)

	move.l	winhandle(A5),a0
	move.l	intsave(a5),a6
	jsr	_LVOrefreshwindowframe(A6)
	rts
*************** Window & Screen freigeben *************************
Closewin:
	bsr	closedownwin
	bra	closedownscreen
********************************************************************
*                  Init Message Struktur                           *
********************************************************************
Sendfirstmessage
	move.l	4,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.s	.error

	move.l	d0,a0			;Portadresse

	move.l	msgport(a5),d3
	move.l	mytask(a5),d4
	move.l	#-1,d5
	move.w	#USclass_Newuserprg,d6

	ifne	debug

	bsr	allocmsg
	beq.s	.error
	move.l	d0,a1			;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)
	move.b	#nt_message,ln_type(a1) ;Message-Typ
	lea	begin(pc),a2
	move.l	a2,um_result(a1)
	move.w	#-2,UM_UserNr(a1)
	move.l	#USM_Userprg,UM_Type(a1)

	move.l	d3,mn_replyport(a1)	;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)
	move.l	d4,UM_TaskAdr(a1)
	move.l	d5,UM_Signal(a1)
	move.w	d6,UM_class(a1)

	move.l	4,a6
	jsr	_LVOputmsg(a6)

	else
	bsr	sendmess
	endc

	moveq	#0,d7
	rts
.error
	moveq	#-1,d7
	rts
*******************************************************************************
sendmess:
	bsr	allocmsg
	bne.s	.ok
	rts
.ok
	move.l	d0,a1			;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)
	move.b	#nt_message,ln_type(a1) ;Message-Typ

	ifne	debug
	move.w	saveusernr(a5),UM_UserNr(a1)
	else
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

	move.l	#USM_Userprg,UM_Type(a1)

	move.l	d3,mn_replyport(a1)	;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)
	move.l	d4,UM_TaskAdr(a1)
	move.l	d5,UM_Signal(a1)
	move.w	d6,UM_class(a1)

	move.l	4,a6
	jmp	_LVOputmsg(a6)
******************************************************************************
* Abschiedsgru an Eagleplayer,der dann wei,da der Analyzer geendet hat    *
******************************************************************************
Sendlastmessage:
	move.l	4,a6
	lea	Portname(pc),a1	;EaglePlayer finden
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.w	.ok	;Eagleplayer hat sich schon verabschiedet

	move.l	d0,a0			;Portadresse
	move.l	msgport(a5),d3
	moveq	#0,d4
	moveq	#0,d5
	move.w	#USclass_exit,d6

	bsr	sendmess
.wait
	move.l	MSGport(a5),a0
	jsr	_LVOwaitport(a6)
	move.l	MSGport(a5),a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	beq.s	.wait
	move.l	d0,a1
	cmp.l	#USM_Userprg,UM_Type(a1)
	beq.s	.meine
.nichtmeine
	jsr	_LVOreplymsg(a6)
	bra.s	.wait
.meine
.ok
	rts
*******************************************************************
*      Public Screen ranholen und Visual Info anfordern           *
*******************************************************************
SetupScreen
	move.l	Intsave(a5),a6
	lea	begin(pc),a0
	move.l	eus_epbase(a0),d0
	beq.s	.noep
	move.l	d0,a0
	move.l	EPG_Pubscreen(A0),d0
	move.w	EPG_Wordreserved7(A0),word7(A5)
.noep
	move.l	d0,a0
	jsr	_LVOLockPubScreen(a6)
	move.l	d0,MyPubscreen(A5)
	beq.s	.error

	move.l	mypubscreen(A5),a0
	move.l	Gadsave(A5),a6
	suba.l	a1,a1
	jsr	_LVOGetVisualInfoA(a6)
	move.l	d0,Vi(A5)
	beq.s	.error     
	moveq	#0,d0
	rts
.error
	moveq	#-1,d0
	rts
*******************************************************************
*      Public Screen ranholen und Visual Info anfordern           *
*******************************************************************
CloseDownScreen:
	push	all
	
	move.l	Gadsave(a5),a6
	move.l	Vi(A5),d0
	beq.s	.novi
	move.l	d0,a0
	jsr	_LVOFreeVisualInfo(a6)
	clr.l	Vi(A5)
.novi
	move.l	Intsave(A5),a6
	suba.l	a0,a0
	move.l	Mypubscreen(A5),d0
	beq.s	.nopub
	move.l	d0,a1
	jsr	_LVOUnlockPubScreen(a6)
	clr.l	Mypubscreen(A5)
.nopub
	pop	all
	rts
GetFont
	tst.b	onsysfont(A5)
	beq.s	.stand

	move.l	grafsave(A5),a6
	lea.l	MyRastPort(a5),a3
	move.l	a3,a1
	jsr	_LVOInitrastport(A6)
	move.l	a3,a1
	lea.l	Attr(a5),a0
	jsr	_LVOAskFont(A6)
	lea.l	Attr(a5),a0
	jsr	_LVOopenfont(A6)
	move.l	d0,fontadr(A5)
	beq.s	.stand
	move.l	d0,a1
	rts
.stand
	move.l	mypubscreen(A5),a1
	lea.l	sc_RastPort(a1),a1
	move.l	rp_Font(a1),a1
	rts
ComputeFont:
	bsr	GetFont

	lea.l	Attr(a5),a0
	move.l	a0,Font(A5)

	move.l  LN_NAME(a1),ta_Name(a0)
	move.w  tf_YSize(a1),ta_YSize(a0)
	move.w  tf_XSize(a1),FontX(A5)
	move.w  tf_YSize(a1),FontY(A5)

	move.l	fontadr(A5),d0
	beq.s	.nofree
	move.l	d0,a1
	move.l	grafsave(A5),a6
	jsr	_LVOclosefont(A6)
.nofree
	move.l	mypubscreen(A5),a0
	move.b	sc_WBorLeft(a0),d0
	ext.w	d0
	move.w	d0,OffX(A5)

	move.l	sc_font(A0),a1
	move.w	ta_YSize(a1),d0

	addq.w	#1,d0
	move.b	sc_WBorTop(a0),d1
	ext.w	d1
	add.w	d1,d0
	move.w	d0,OffY(A5)

	tst.w	d2
	beq.s	CompDone
	tst.w	d3
	beq.s	CompDone
	move.w	d2,d0
	bsr	ComputeX

	add.w   OffX(A5),d0
	move.b	sc_WBorRight(a0),d1
	ext.w	d1
	add.w	d1,d0
	cmp.w	sc_Width(a0),d0

	ifne	test
	bra.s	Usetopaz
	endc

	bhi.s	UseTopaz
	move.w	d0,d2

	move.w	d3,d0
	bsr	ComputeY
	add.w	OffY(a5),d0
	move.b	sc_WBorBottom(a0),d1
	ext.w	d1
	add.w	d1,d0
	cmp.w	sc_Height(a0),d0
	bhi.s	UseTopaz
	move.w	d0,d3
CompDone:
	rts
UseTopaz:
	add.w   OffX(A5),d2
	move.b	sc_WBorRight(a0),d1
	ext.w	d1
	add.w	d1,d2

	add.w	OffY(a5),d3
	move.b	sc_WBorBottom(a0),d1
	ext.w	d1
	add.w	d1,d3

	move.l	Font(A5),a0
	move.l	#TopazName,ta_Name(a0)
	move.w	#8,FontY(A5)
	move.w	#8,FontX(a5)
	move.w	#8,ta_YSize(a0)
	rts
ComputeX:
	move.l	d1,-(sp)
	move.w	FontX(a5),d1
	bra.s	ComputeItX
ComputeY:
	move.l	d1,-(sp)
	move.w	FontY(A5),d1
	mulu	d1,d0
	addq.w	#4,d0
	lsr.w	#3,d0
	move.l	(sp)+,d1
	rts
ComputeItX:
	mulu	d1,d0
	addq.w	#4,d0
	lsr.w	#3,d0
	move.l	(sp)+,d1
	rts

*------------ Hookfunktion, um aktuellen Modus farblich hervorzuheben ------*
*---------------- derzeit noch kein Support fr "disabled"-Gadgets ---------*
*benutzte Globals:
* - grafsave+datas = Graphics Base
*
*Erkennung, ob Zeile hervorzuheben oder nicht:
* -  erstes Zeichen im darzustellenden Text ist ein "|"
	;a0:Hook
	;a1:Message
	;a2:Node
my_hook
	push	d1-a6

	move.l	lvdm_MethodID(a1),d1
	cmp.l	#LV_Draw,d1
	bne.w	.hi
	move.l	a1,a4
	move.l	lvdm_RastPort(a4),d7
	beq.w	.hi

	move.l	grafsave+datas,a6			;Graphics Base

	move.l	lvdm_DrawInfo(A4),d0
	beq.w	.hi
	move.l	d0,a1
	move.l	dri_Pens(a1),a1

	sf	d2
	move.l	ln_name(A2),a5		;
	cmp.b	#`|`,(a5)		; Test ob hervorzuheben oder nicht
	bne.s	.textpen
	st	d2

	addq.l	#1,a5
	move	highlighttextpen*2(a1),d0
	bra.s	.high
.textpen
	move	textpen*2(a1),d0
.high
	move	backgroundpen*2(a1),d6

	cmp.l	#LVR_SELECTED,lvdm_State(a4)
	bne.s	.normalBG
	move	FILLPEN*2(a1),d6
	move	textpen*2(a1),d0
	tst.b	d2
	beq.s	.normalBG
	move	highlighttextpen*2(a1),d0
.normalBG
	move	d6,d1
	moveq	#RP_Jam1,d2
	move.l	d7,a1
	jsr	_LVOsetabpendrmd(A6)

	move.w	lvdm_bounds+ra_minx(a4),d0
	move.w	lvdm_bounds+ra_miny(a4),d1
	move.l	d7,a1
	add	rp_TxBaseline(a1),d1
	jsr	_LVOMove(A6)

	move.l	d7,a1
	moveq	#RP_Jam2,d0
	jsr	_LVOsetdrmd(A6)

	move.w	lvdm_bounds+ra_maxx(a4),d5		;Begrenzung des Textes
	sub	lvdm_bounds+ra_minx(a4),d5		;auf Breite des
	blt	.hi					;Listviews, solange

	move.l	a5,a0					;Text
	moveq	#-1,d3					;bis der Text passt
.lop
	addq	#1,d3
	tst.b	(a0)+
	bne.s	.lop
.charloop
	move.l	d7,a1
	move.l	a5,a0					;Text
	move.w	d3,d0
	jsr	_LVOtextlength(A6)
	cmp.w	d5,d0
	blt.s	.ok
	subq.w	#1,d3
	bra.s	.charloop
.ok
	move	d0,d4
	move.w	d3,d0
	move.l	a5,a0					;Text
	move.l	d7,a1
	jsr	_LVOtext(A6)

	move.l	d7,a1
	move	d6,d0
	move	d6,d1
	moveq	#0,d2
	jsr	_LVOsetabpendrmd(A6)

	move	lvdm_bounds+ra_minx(a4),d0
	add	d4,d0
	move	lvdm_bounds+ra_miny(a4),d1
	move	lvdm_bounds+ra_maxx(a4),d2
	move	lvdm_bounds+ra_maxy(a4),d3
	move.l	d7,a1
	jsr	_LVORectfill(a6)	;freien Platz nach dem Text lschen
	
	pop	d1-a6
	moveq	#LVCB_OK,d0
	rts
.hi
	pop	d1-a6
	moveq	#LVCB_Unknown,d0
	rts
CreateGadgets
	move.l	Gadsave(A5),a6
	lea.l	Project0GList(a5),a0
	jsr	_LVOCreateContext(a6)
	move.l	d0,a3
	tst.l	d0
	beq.w	.Project0CError

	moveq	#0,d3
	lea.l	Project0GTags(pc),a4
.Project0GL:
	move.l	4,a6
	lea.l	Project0NGads(pc),a0
	move.l	d3,d0
	mulu	#gng_SIZEOF,d0
	add.l	d0,a0
	lea.l	BufNewGad(a5),a1
	moveq	#gng_SIZEOF,d0
	jsr	_LVOCopyMem(a6)
	lea.l	BufNewGad(a5),a0
	move.l	Vi(a5),gng_VisualInfo(a0)
	move.l	Font(a5),gng_TextAttr(a0)

	move.w	gng_LeftEdge(a0),d0
	bsr	computex
	add.w	OffX(a5),d0
	move.w	d0,gng_LeftEdge(a0)

	move.w	gng_TopEdge(a0),d0
	bsr	computey
	add.w	OffY(a5),d0
	move.w	d0,gng_TopEdge(a0)

	move.w	gng_Width(a0),d0
	bsr	computex
	move.w	d0,gng_Width(a0)

	move.w	gng_Height(a0),d0
	bsr	computey
	move.w	d0,gng_Height(a0)

	move.l	Gadsave(a5),a6
	lea.l	Project0GTypes(pc),a0
	moveq	#0,d0
	move.l	d3,d1
	asl.l	#1,d1
	add.l	d1,a0
	move.w	(a0),d0
	move.l	a3,a0
	lea.l	BufNewGad(a5),a1
	move.l	a4,a2
	jsr	_LVOCreateGadgetA(a6)
	tst.l	d0
	bne.s	.Project0COK
	bra	.Project0CError
.Project0COK:
	move.l	d0,a3
	move.l	d3,d0
	asl.l	#2,d0
	lea.l	Project0Gadgets(a5),a0
	add.l	d0,a0
	move.l	a3,(a0)
.Project0TL:
	tst.l	(a4)
	beq.s	.Project0DN
	addq.w	#8,a4
	bra.s	.Project0TL
.Project0DN:
	addq.w	#4,a4
	addq.w	#1,d3
	cmp.w	#Project0_CNT,d3
	bmi	.Project0GL
.Project0CError
	rts
*************************************************************************
*            Fenster ffnen, Gadgets und Mens init                     *
*************************************************************************
SetUpWin:
	movem.l d1-d4/a0-a4/a6,-(sp)

	move.l	mypubscreen(a5),a0
	move.l  sc_Font(a0),a1
	move.w  ta_YSize(a1),d3
	addq.w  #1,d3
	move.b  sc_WBorTop(a0),d0
	ext.w   d0
	add.w	d3,d0
	move.w	d0,offy(a5)

	move.b  sc_WBorLeft(a0),d0
	ext.w   d0
	move.w	d0,offx(a5)

	move.w	#Project0Width,d2
	move.w	#Project0Height,d3

	bsr	ComputeFont
	move.l	mypubscreen(A5),a0

	move.l	d2,ahawidth
	move.l	d3,ahaheight

	move.l	d2,d0
	move.l	d0,d4

	moveq	#0,d2
	add.w	d2,d0
	add.w	OffX(a5),d0
	move.b	sc_WBorRight(a0),d1
	ext.w	d1
	add.w	d1,d0
	cmp.w	sc_Width(a0),d0
	bls.s	.Project0WOk
	move.w	sc_Width(a0),d0
	sub.w	d4,d0
	move.w	d0,d2
.Project0WOk:
	move.l	d3,d0
	move.l	d0,d4

	lea	begin(pc),a1
	move.w	eus_winy(a1),d3
	add.w	d3,d0

	add.w	OffY(A5),d0
	move.b	sc_WBorBottom(a0),d1
	ext.w	d1
	add.w	d1,d0
	cmp.w	sc_Height(a0),d0
	bls.s	Project0HOk
	move.w	sc_Height(a0),d0
	sub.w	d4,d0
	move.w	d0,d3
Project0HOk:
	move.l	Gadsave(A5),a6
	lea.l	Project0NewMenu0(pc),a0

	move.w	Hiercheck_Mono(pc),d0		;Meneintrag: Mono aus den prefsssetzen
	and.w	#~Checked,d0
	move.b	Begin+OnMonoMode(pc),d1
	beq.s	.noset
	or.w	#Checked,d0
.noset	move	d0,HierCheck_Mono	

	lea.l	MTags0(pc),a1
	jsr	_LVOCreateMenusA(a6)

	move.l	d0,Project0Menus(A5)
	tst.l	d0
	beq	Project0MError
	move.l	d0,a0
	move.l	Vi(A5),a1
	lea.l	mtags0(pc),a2
	jsr	_LVOLayoutMenusA(a6)

	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	moveq	#0,d7
	lea	begin(Pc),a1
	move	eus_Winx(a1),d0
	move	eus_Winy(a1),d1
	move	ZoomPosX(a1),d2
	move	ZoomPosY(a1),d3

	move.l	ahawidth(pc),d4
	move.l	ahaheight(pc),d5
	move.l	#ZoomWidth,d6
	move	offy(A5),d7

	tst.b	ZoomState(a1)
	beq.s	.Normal
	exg.l	d0,d2
	exg.l	d1,d3
	exg.l	d4,d6
	exg.l	d5,d7
.normal
	lea.l	Project0WindowTags(pc),a1
	move.l	d0,Project0L+4-Project0WindowTags(A1)
	move.l	d1,Project0T+4-Project0WindowTags(A1)
	move.l	d4,Project0W+4-Project0WindowTags(A1)
	move.l	d5,Project0H+4-Project0WindowTags(A1)
	move.w	d2,ZoomStruct-Project0WindowTags(A1)
	move.w	d3,ZoomStruct+2-Project0WindowTags(A1)
	move	d6,ZoomStruct+4-Project0WindowTags(A1)
	move	d7,ZoomStruct+6-Project0WindowTags(A1)

	move.l	Intsave(A5),a6
	move.l	mypubscreen(a5),Pubadr-Project0WindowTags(a1)
	suba.l	a0,a0
	jsr	_LVOOpenWindowTagList(a6)
	move.l	d0,Winhandle(a5)
	tst.l	d0
	beq	Project0WError
.open13
	move.l	Winhandle(a5),a0
	move.l	Project0Menus(A5),a1
	jsr	_LVOSetMenuStrip(a6)

	bsr	createGadgets

	bsr	AddGads

	moveq	#0,d0
Project0Done:
	movem.l	(sp)+,d1-d4/a0-a4/a6
	rts
Project0CError:
	moveq	#1,d0
	bra.s	Project0Done
Project0GError:
	moveq	#2,d0
	bra.s	Project0Done
Project0MError:
	moveq	#3,d0
	bra.s	Project0Done
Project0WError:
	moveq	#4,d0
	bra.s	Project0Done

AddGads:
	movem.l	d0-a6,-(sp)
	move.l	Project0GList(a5),d0
	beq.s	.nogads
	move.l	d0,a1

	moveq	#0,d1
.count
	move.l	d0,a0

	addq.l	#1,d1

	move.l	(A0),d0
	bne.s	.count

	move.w	d1,RealNumGadgets(A5)

	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	moveq	#-1,d0
	moveq	#-1,d1
	suba.l	a2,a2
	jsr	_LVOaddglist(a6)

	move.l	Project0GList(a5),a0
	move.l	winhandle(a5),a1
	suba.l	a2,a2
	moveq	#-1,d0
	jsr	_LVOrefreshglist(a6)

	move.l	GadSave(a5),a6
	move.l	Winhandle(a5),a0
	suba.l	a1,a1
	jsr	_LVOGT_RefreshWindow(a6)

	bsr	UpdateList
.nogads
	movem.l	(sp)+,d0-a6
	rts
*************************************************************************
*            Fenster schlieen, Gadgets und Mens free                  *
*************************************************************************
Closedownwin:
	push	all
	move.l	Intsave(A5),a6
	move.l	Project0Menus(A5),a0
	cmpa.l	#0,a0
	beq	Project0NMenu
	move.l	Winhandle(a5),a0
	jsr	_LVOClearMenuStrip(a6)
	move.l	GadSave(a5),a6
	move.l	Project0Menus(A5),a0
	jsr	_LVOFreeMenus(a6)
	move.l	#0,Project0Menus(A5)
Project0NMenu:
	move.l	Intsave(A5),a6
	move.l	Winhandle(a5),d0
	beq.s	.nowin
	move.l	d0,a0
	jsr	_LVOCloseWindow(a6)
	clr.l	Winhandle(a5)
	clr.l	port(a5)
.nowin
	bsr	Freegadgets
	pop	all
	rts
FreeGadgets
	movem.l	d0-a6,-(sp)

	move.l	GadSave(a5),a6
	move.l	Project0GList(A5),a0
	cmpa.l	#0,a0
	beq	.nogad
	jsr	_LVOFreeGadgets(a6)
	clr.l	Project0GList(A5)
.nogad
	movem.l	(sp)+,d0-a6
	rts
*************************************************************
*    Gadgetadresse ausrechnen                               *
* Input D0 - Gadgetnummer (0 < X < MAX)                     *
*************************************************************
_Gadr
	lea	Gadgetadrs(a5),a0
	asl.l	#2,d0
	move.l	(a0,d0),a0
	rts
*************************************************************
*           Nachrichtenbearbeitung                          *
*************************************************************
HandleActions
.ma
	move.l	gadsave(a5),a6

	move.l	port(a5),d0
	beq.s	.nowinny
	move.l	d0,a0
	jsr	_LVOGT_getimsg(a6)
	tst.l	d0
	bne	.msg
.nowinny
	move.l	4,a6
	
	move.l	msgport(a5),a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	bne	.AN_msg

	bsr	UpdateDownGadgets
	bne	.ma

	moveq	#0,d0
	move.l	4,a6

	ifne	userprogram
	move.l	msgport(a5),a0
	move.b	mp_sigbit(a0),d1
	bset	d1,d0
	endc

	move.l	Port(a5),d2
	beq.s	.nomain
	move.l	d2,a0
	move.b	mp_sigbit(a0),d1
	bset	d1,d0
.nomain
	move.l	mysignal(a5),d3	;Signal fr Analyzer
	bset	d3,d0		;Signalbit fr Abarbeitung des Analyzers selbst
				;(Auswertungsroutine namens "ANALYZE1")
	jsr	_LVOwait(a6)
	bra	.ma
;======================= Message an Hauptwindow ============================
.msg
	move.l	d0,a1
	move.l	im_class(a1),d7
	move.w	im_code(a1),d5 		<- Fr Tastatur / Selnummer Listview
	move.l	im_Iaddress(a1),d6 	<- Fr Gadgetabfrage
	move.l	im_seconds(a1),d2	<- fr Doppelclick
	move.l	im_micros(a1),d3	<- auch f. Doppelclick
	jsr	_LVOGT_replyimsg(a6)

	cmp.l	#IDCMP_Changewindow,d7	;Refresh
	bne.s	.nochangewin
	lea	begin(pc),a1

	move.l	winhandle(a5),a0
	move	OffY(A5),d0
	cmp	wd_height(a0),d0
	bne.s	.setposun
	move.w	wd_leftedge(a0),ZoomPosX(a1)
	move.w	wd_topedge(a0),ZoomPosY(a1)
	st	ZoomState(a1)
	bra	.ma
.setposun
	move.w	wd_leftedge(a0),EUS_WinX(a1)
	move.w	wd_topedge(a0),EUS_Winy(A1)
	sf	ZoomState(a1)
	bra	.ma
.nochangewin
	cmp.l	#refreshwindow,d7	;Refresh
	bne.s	.noref
	pea	.ma(pc)
.ref
	bsr	clearwin

	move.l	gadsave(a5),a6
	move.l	winhandle(a5),a0	;*Window
	jsr	_LVOGT_beginrefresh(A6)

	move.l	winhandle(a5),a0	;*Window
	moveq	#1,d0
	jsr	_LVOGT_Endrefresh(A6)	

	bsr	drawbevel
	rts
	;------------------ Gadgets abfragen ------------------------
.noref
	cmp.l	#Gadgetup,d7
	bne.w	.notup

	move.l	d6,a1

	move.w	gg_gadgetid(A1),d4	;ID Fr Gadgets

	bsr	TestGadgets
	bra	.ma
.notup
	cmp.l	#Gadgetdown,d7
	bne.w	.notgad

	move.l	d6,a1

	move.w	gg_gadgetid(A1),d4	;ID Fr Gadgets

	bsr	TestDOWNGadgets
	bra	.ma

	;------------------------- Mens abfragen ----------------------------
.menuloop
	move.l	temp(A5),a1
	move.w	mi_nextselect(A1),d5
	bra.s	.menuwei
.notgad:
	cmp.l	#menupick,d7
	bne.w	.nomenu
.menuwei
	move.w	d5,d0
	cmp.w	#menunull,d0
	beq	.ma

	move.l	Project0Menus(A5),a0
	move.l	intsave(a5),a6
	jsr	_LVOitemaddress(a6)
	move.l	d0,a1
	tst.l	d0
	beq	.ma
	move.l	d0,temp(A5)

	move.w	d5,d0
	and.w	#$1f,d0
	bne.s	.2ndmenu
	move.w	d5,d0
	and.w	#$7e0,d0
	bne.s	.noMonoMode

	move.w	mi_flags(a1),d0
	and.w	#checked,d0
	move.w	d0,d1
	lsr.w	#4,d0
	move.b	d0,begin+OnMonoMode

	move.w	Hiercheck_Mono(pc),d0
	and.w	#~Checked,d0
	or.w	d1,d0
	move.w	d0,Hiercheck_Mono
	bra	.menuloop
.noMonoMode
	cmp.w	#64,d0
	bne.s	.noabout		;1. Item (About) ?
	lea	Aboutmessage(pc),a0
	bsr	Merror
	bra	.menuloop
.noabout
	cmp.w	#96,d0			;2. Item (Hide)
	beq.w	.quitit
	cmp.w	#128,d0			;3. Item (Quit)
	beq	.killit
	bra	.menuloop
.2ndmenu				;2. Men
	move.w	d5,d0
	and.w	#$7e0,d0
	bne.s	.noglobal

	move.w	mi_flags(a1),d0
	and.w	#checked,d0
	move.w	d0,d1
	lsr.w	#4,d0
	move.b	d0,Onglobal(A5)

	move.w	Hiercheck(pc),d0
	and.w	#~Checked,d0
	or.w	d1,d0
	move.w	d0,hiercheck

	bsr	SetVoic

	bra	.menuloop
.noglobal
	cmp	#64,d0
	bne.s	.nodefaults

	bsr	Makedefaults			;Default prefs setzen
	bsr	Updatelist

	move.w	SelectedW(a5),d0
	mulu	#10,d0
	lea	Prefslist(a5),a0
	move.l	(A0,d0.w),d0
	bsr	CalcValues

	moveq	#0,d0
	bsr	SetPlaymode

	move.w	SelectedW(a5),d0
	mulu	#10,d0
	lea	Prefslist+7(a5),a0
	move.b	(A0,d0.w),d0
	bsr	setPrefetch

	bra	.menuloop
.nodefaults
	cmp.w	#96,d0
	bne	.nosavepref
	bsr	SaveConfig
.nosavepref
	bra	.menuloop
.nomenu
	cmp.l	#rawkey,d7
	bne	.nokey

	cmp.b	#$21,d5
	bne.s	.noS

	lea	Prefslist+6(a5),a0

	tst.b	onglobal(A5)
	bne.s	.sliPMglobal

	move.w	SelectedW(a5),d0
	mulu	#10,d0
	clr.b	(A0,d0.w)
	bra.s	.sliPMup
.sliPMglobal
	moveq	#31-1,d0
.sliPMall
	clr.b	(A0)			;Playmode
	add.w	#10,a0
	dbf	d0,.sliPMall
.sliPMup
	bsr	UpdateList		;Spter nur Listview update !!!!
	moveq	#0,d0
	bsr	SetPlaymode
	bra	.ma
.noS
	cmp.b	#$45,d5			;ESC
	beq	.quitit
	bra	.ma
.nokey
	cmp.l	#CloseWindow,d7
	bne	.ma
.quitit
	ifne	userprogram

	bsr	closewin

	move.l	4,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.s	.endme		;kein Eagleplayerport->Ende des Programmes
	move.l	d0,a0			;Portadresse
	move.l	msgport(a5),d3
	move.l	mytask(a5),d4
;	move.l	mysignal(a5),d5
	move.l	#-1,d5
	move.w	#USclass_Hide,d6		;DeActivate,d6
	bsr	sendmess
	bra	.ma

	endc
.endme
	moveq	#-1,d7
	rts
.killit
	moveq	#0,d7
	RTS
;===================== Message an Userprogramm Port =====================
	ifne	userprogram
.AN_msg
	move.l	d0,a1

	move.l	MSGPort(a5),UM_Userport(a1)

	lea	begin(pc),a2

	ifne	debug
	move.w	um_usernr(a1),saveusernr(A5)
	else
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

	move.l	mytask(a5),UM_TaskAdr(a1)
;	move.l	mysignal(a5),d1
	move.l	#-1,d1
	move.l	d1,UM_Signal(a1)

	move.w	UM_class(a1),d3		<-
	cmp.w	#USclass_exit,d3
	bne.w	.noex1

	clr.l	um_signal(a1)
	clr.l	um_taskadr(a1)
	clr.l	um_userport(a1)
.noex1
	move.l	UM_Type(a1),d7
	move.l	UM_structadr(a1),d6 	<-

	clr.w	UM_class(A1)

	cmp.w	#USclass_Saveconfig,d3
	bne	.nosavepref1
	bsr	SaveConfig
.nosavepref1
	cmp.w	#USclass_getconfig,d3		;when this command comes,set
						;the actual preferences into
						;the Eagleuser-Structure
						;(EUS_-structure at the be-
						;ginning of the program)
	bne	.noprev

	move.w	eus_flags(a2),d0
	and.w	#~EUSB_Show,d0

	move.l	winhandle(A5),d1		;Window
	beq.s	.prnowin			;no Window opened,no change
						;of preferences
	or.w	#eusb_Show,d0			;set Flag: window is open

	move.l	d1,a0				;Window
	move.w	wd_leftedge(a0),eus_winx(a2)	;Save Windowpostion
	move.w	wd_topedge(a0),eus_winy(a2)

;	move.w	wd_width(a0),d2
;	moveq	#0,d1
;	move.b	wd_borderleft(A0),d1
;	sub.w	d1,d2
;	move.b	wd_borderright(A0),d1
;	sub.w	d1,d2
.prnowin
	move.w	d0,eus_flags(a2)		;Save Flags
.noprev

	cmp.w	#USCLASS_Show,d3
	bne.s	.noshow

	move.l	MYEpBase(pc),a0
	move.l	EPG_SomePrefs(a0),d0
	btst	#EGPRF_Iconify,d0
	bne.w	.noshow

	push	all
	bsr	Openwin
	pop	all
	tst.l	Winhandle(A5)
	beq.s	.noshow
	move	d3,UM_Class(a1)
.noshow

	cmp.w	#USclass_Hide,d3
	bne.s	.noclosewin
	bsr	Closewin
.noclosewin

	move.l	mn_replyport(a1),d0
	cmp.l	MSGport(a5),d0		 ;eine von uns abgeschickte Message ?
	beq.s	.noreply
	jsr	_LVOreplymsg(a6)
.noreply
	
	cmp.l	#USM_Userprg,d7	;Message zurckbekommen ?
	bne.s	.nomy

	move.b	#0,messagesent(a5)	;merken,da Message-Struktur frei
	bra	.mess	;eventl. Message vom Esagle auswerten

.nomy
	cmp.l	#USM_Eagleplayer,d7	;Hat EaglePlayer was zu melden ?
	bne.w	.noeagle		;n
.mess

;	lea	begin(pc),a0
;	move.l	eus_epbase(a0),a0
;	move.b	EPG_Wordreserved7(a0),d0
;	beq	.killit

;	move.l	d6,an_structadr(a5)
.refre
	cmp.w	#USclass_Dummy,d3	;leere Message,nur neue Analyzer-
	beq.w	.ma			;adresse bekommen
	cmp.w	#USclass_killmodule,d3
	bne.s	.nokill

	move	#-1,Currentnumvoc(a5)
	bsr	MakeLV

.nokill
	cmp.w	#USclass_zipwin,d3
	bne.s	.nozip
.setzip
	move.l	4,a6
	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	wd_height(a0),d0
	cmp.w	myhoehe1(a5),d0
	beq.w	.ma		;Window schon klein
.zip
	move.w	d0,-(sp)

	move.l	intsave(a5),a6
	jsr	_LVOzipwindow(a6)

	move.w	(sp)+,d4

	move.l	winhandle(a5),a2
.Zipwait:
	moveq	#2,d1
	move.l	_Dos(a5),a6
	jsr	_LVODelay(a6)

	cmp.w	wd_height(a2),d4
	beq.s	.zipwait

	bra	.ma
.nozip
	cmp.w	#USclass_unzipwin,d3
	bne.s	.nounzip

.clearzip
	move.l	4,a6
	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	wd_height(a0),d0
	cmp.w	myhoehe1(a5),d0
	beq.s	.zip
	bra	.ma
.nounzip
	cmp.w	#USclass_exit,d3
	beq	.endme

;	cmp.w	#USclass_Show,d3
;	beq.s	.win
;	cmp.w	#USclass_Activate,d3
;	bne.w	.nowin
;.win
;	bsr	Openwin
;	bra	.ma
;.nowin
	cmp.w	#USclass_NewConfig,d3	;is there a new config
	bne.w	.nonewcon		;no

	lea	begin(pc),a0		;start of program (EUS_-Structure)
	move.w	eus_flags(a0),d0	;get Flags
	btst	#eusf_openwin,d0	;Window open ?
	beq.s	.nowino
	bsr	openwin			;open it
	bra.s	.weio
.nowino
	bsr	closewin		;else close it
.weio
	lea	begin(pc),a0		;start of program (EUS_-Structure)
	move.l	winhandle(a5),d0	;windowaddress
	beq.s	.nothingtomove		;no Window , no movement

	move.l	d0,a1			;Window
	move.l	wd_wscreen(a1),a2	;Parent Screen

	move.w	eus_winx(a0),d0		;new X-position
	move.w	d0,d1			;save
	blt.s	.oldx			;less than 0 -> stop

	add.w	wd_width(a1),d1		;new position + Window-width
	cmp.w	sc_width(a2),d1		;bigger than Screenwidth ?
	bhi.s	.oldx			;then old X-position (Delta = 0)

	sub.w	wd_leftedge(a1),d0	;new - old X-position = Delta X
	bra.s	.gety
.oldx
	moveq	#0,d0			;Delta X = 0
.gety
	move.w	eus_winy(a0),d1		;new Y-position

	move.w	d1,d2			;save
	blt.s	.oldy			;less than 0 -> stop and take old

	add.w	wd_height(a1),d2	;new position + window-height
	cmp.w	sc_height(a2),d2	;bigger than Screenheight ?
	bhi.s	.oldy

	sub.w	wd_topedge(a1),d1	;new - old Y-position = Delta Y
	bra.s	.setdeltas
.oldy	moveq	#0,d1

.setdeltas
	move.l	intsave(a5),a6		;Intuition
	move.l	a1,a0			;Winhandle
	jsr	_LVOmovewindow(A6)
.nothingtomove
	lea	begin(pc),a0
	move.w	eus_flags(a0),d0
	btst	#eusf_zipwin,d0		;Zipwindow ?
	bne	.setzip			;yes
	bra	.clearzip		;no
.nonewcon
	bra	.ma
.noeagle
	bra	.ma
	endc
*********************** Finde Tag ber EP Funktion ***************************
FindTag
	movem.l	a1/a5,-(sp)
	move.l	myEPBase(pc),a5
	move.l	EPG_FindTag(a5),a1
	jsr	(a1)
	movem.l	(sp)+,a1/a5
	rts
*****************************************************************
allocmsg
	movem.l	d1-a6,-(sp)
	move.l	4,a6
	moveq	#UM_Sizeof,d0
	move.l	#$10001,d1
	jsr	_LVOallocmem(A6)
	movem.l	(sp)+,d1-a6
	tst.l	d0
	rts
*****************************************************************
freemsg
;	moveq	#UM_sizeof,d0

	moveq	#0,d0
	move.w	mn_length(a1),d0
	add.w	#20,d0
	move.l	4,a6
	jsr	_LVOfreemem(A6)
	rts
******************************************************************************
*                       Ausgabe von Error-Messages                           *
*                 Input: a0 -> Zeiger auf Ausgabestring                      *
******************************************************************************
MERROR:
	movem.l	d0/a2-a3,-(sp)
	suba.l	a3,a3			;*Arguments
	lea	my_easygadget(pc),a2
	bsr	Errorout
	movem.l	(sp)+,d0/a2-a3
	rts
Errorout
	movem.l	d1-a6,-(sp)
	move.l	Intsave(a5),a6
	lea	my_easystruct(a5),a1

	move.l	a0,es_textformat(a1)

	move.l	a2,es_gadgetformat(a1)

	lea	my_easytitle(pc),a0
	move.l	a0,es_Title(a1)
	move.l	winhandle(a5),a0	;*Window
	suba.l	a2,a2			;*IDCMP_ptr
	jsr	_LVOeasyrequestargs(a6)			;!! durch Reqtools
							;ersetzen
	movem.l	(sp)+,d1-a6	
	rts

;============= Save Player Config Routine ===========================
SaveConfig:
	movem.l	d0-a6,-(sp)
	
	move.l	4.w,a6
	lea	dos(pc),a1
	moveq	#33,d0
	jsr	_LVOopenlibrary(A6)	;Open DOS
	tst.l	d0
	beq	.error
	move.l	d0,dosbase
	move.l	d0,a6

	move.l	myepbase(pc),a0
	move.l	EPG_ConfigDirArrayPtr(a0),d1
	moveq	#-2,d2			;access_read
	jsr	_LVOlock(a6)
	tst.l	d0
	beq	.nolock			;Path not found
	move.l	d0,d1
	jsr	_LVOcurrentdir(A6)
	move.l	d0,d7

	lea	savename(pc),a1
	move.l	a1,d1
	move.l	#1006,d2		;MODE_NEWFILE
	jsr	_LVOopen(A6)
	move.l	d0,d6
	beq.s	.fail

	move.l	d0,d1				;Handle
	lea	ConfigDatas(A5),a1
	move.l	a1,d2				;Adr
	move.l	#ConfigDatasEND-ConfigDatas,d3	;len
	jsr	_LVOwrite(a6)

	move.l	d6,d1
	jsr	_LVOclose(a6)
.fail
	move.l	d7,d1
	jsr	_LVOCurrentdir(A6)
	move.l	d0,d1
	jsr	_LVOUnlock(A6)
.nolock
	move.l	a6,a1
	move.l	4.w,a6
	jsr	_LVOcloselibrary(A6)
.error
	movem.l	(Sp)+,d0-a6
	rts
;============= Load Player Config Routine ===========================
Loadconfig:
	movem.l	d0-a6,-(sp)

	move.l	4.w,a6
	lea	dos(pc),a1
	moveq	#33,d0
	jsr	_LVOopenlibrary(A6)	;Open DOS
	tst.l	d0
	beq	.error
	move.l	d0,dosbase
	move.l	d0,a6

	move.l	myepbase(pc),a0
	move.l	EPG_ConfigDirArrayPtr(a0),d1
	moveq	#-2,d2			;access_read
	jsr	_LVOlock(a6)
	tst.l	d0
	beq	.nolock			;Path not found
	move.l	d0,d1
	jsr	_LVOcurrentdir(A6)
	move.l	d0,d7

	lea	savename(pc),a1
	move.l	a1,d1
	move.l	#MODE_Oldfile,d2		;MODE_NEWFILE
	jsr	_LVOopen(A6)
	move.l	d0,d6
	beq.s	.fail

	move.l	d0,d1				;Handle
	lea	ConfigDatas(A5),a1
	move.l	a1,d2				;Adr
	move.l	#ConfigDatasEND-ConfigDatas,d3	;len
	jsr	_LVOread(a6)

	move.l	d6,d1
	jsr	_LVOclose(a6)
.fail
	move.l	d7,d1
	jsr	_LVOCurrentdir(A6)
	move.l	d0,d1
	jsr	_LVOUnlock(A6)
.nolock
	move.l	a6,a1
	move.l	4.w,a6
	jsr	_LVOcloselibrary(A6)
.error
	movem.l	(sp)+,d0-a6
	rts

dosbase:	dc.l    0       ; Dos-Lib Basisadresse
savename:	dc.b	`8_Bit_Amplifier.cfg`,0

	cnop	0,4
********************************************************************
*               initialize default preferences                     *
********************************************************************
Makedefaults:
	movem.l	d0-a6,-(sp)

	lea	Prefslist(a5),a0
	move.l	#28000,d0			;Rate
	moveq	#10,d1				;VBoost "1.0"
	move.w	#$0000+Samlen/10,d2		;Effect (Stereo+Delay 350bytes)
	moveq	#0,d4				;Flags

	moveq	#32-1,d3
.defaults
	move.l	d0,(a0)+			;mixrate.l
	move.w	d1,(a0)+			;vboost.w
	move.w	d2,(a0)+			;effect.w
	move.w	d4,(a0)+			;flags.w
	sub.l	#500,d0
	addq.w	#1,d5
	and.w	#3,d5
	bne.s	.no
	addq.w	#1,d1
.no
	dbf	d3,.defaults

	movem.l	(sp)+,d0-a6
	rts
*****************************************************************************
*                        Gedrckte Gadgets abfragen                         *
* A1 - aktuelle Gadgetstruktur                                              *
* D4 - Gadget ID                                                            *
*****************************************************************************
TestGadgets:
	cmp.w	#GD_Listview,d4		;Listview-Gadget
	bne.s	.noidlv

	move.w	SelectedW(A5),d6	;aktuell angeclickter Modus
	move.w	d5,SelectedW(A5)

	cmp.w	d5,d6			;kein Doppelklick
	beq	.testdoub

	move.l	d2,Seconds(a5)
	move.l	d3,Micros(a5)

	bsr	UpdateList
	bra	.endit
.testdoub
	move.l	Seconds(a5),d0
	move.l	Micros(a5),d1
	move.l	d2,Seconds(a5)
	move.l	d3,Micros(a5)
	move.l	intsave(a5),a6
	jsr	_LVOdoubleclick(a6)
	cmp.l	#1,d0
	bne.w	.disp

	clr.l	Seconds(a5)
	
	mulu	#10,d6
	lea	Prefslist(a5),a0
	move.w	8(A0,d6.w),d0		;Flags.w (Bit0=disable)
	eor.w	#1,d0
	move.w	d0,8(a0,d6.w)
.disp
	bsr	UpdateList
	bra	.ma
.noidlv
	cmp.w	#GD_VBOOST,d4		;Volume Boost Slider-Gadget
	bne.s	.noidBoost

	sf	onvboostslider(A5)

	tst.b	onglobal(A5)
	bne.s	.sli2global

	move.w	SelectedW(a5),d0
	mulu	#10,d0
	lea	Prefslist+4(a5),a0
	move.w	d5,(A0,d0.w)
	bra.s	.sli2up
.sli2global
	lea	Prefslist+4(a5),a0
	moveq	#31-1,d0
.sli2all
	move.w	d5,(A0)
	add.w	#10,a0
	dbf	d0,.sli2all
.sli2up
	bsr	makedivtabs

;	bsr	UpdateList		;Spter nur Listview update !!!!

	bsr	SetVBoost
	bsr	MakeLV			;Listview in Ordnung bringen
	bra	.ma
.noidBoost
	cmp.w	#GD_Samplefreq,d4
	bne.s	.noidsam1

	move.l	gg_specialinfo(a1),a0	;Stringinfo Struktur
	move.l	si_Longint(A0),d1	;Wert des Gadgets
	cmp.l	#4000,d1
	bgt.s	.ok1
	move.l	#4000,d1
.ok1
	cmp.l	#65500,d1		;78000,d1
	ble.s	.ok2
	move.l	#65500,d1		;78000,d1
.ok2
	bra.s	.sli1set
;	bra	.ma
.noidsam1
	cmp.w	#GD_MixingSlider,d4
	bne.s	.nosli

	sf	onmixingslider(A5)

	move.w	#10,d1
	mulu	d5,d1
.sli1set
	tst.b	onglobal(A5)
	bne.s	.sli1global

	move.w	SelectedW(a5),d0
	mulu	#10,d0
	lea	Prefslist(a5),a0
	move.l	d1,(A0,d0.w)
	bra.s	.sli1up
.sli1global
	lea	Prefslist(a5),a0
	moveq	#31-1,d0
.sli1all
	move.l	d1,(A0)
	add.w	#10,a0
	dbf	d0,.sli1all
.sli1up
;	bsr	UpdateList		;Spter nur Listview update !!!!

	bsr	MakeLV
	bsr	SetRate
	bsr	SetLevel

	bsr	CalcValues
	bra	.endit
.nosli
	cmp.w	#GD_Playmode,d4		;Playmode Slider
	bne.s	.noPlmode

	sf	onPlaymodeslider(A5)
					;d5: -64 <-> 64
	tst.b	onglobal(A5)
	bne.s	.slipmodeG

	move.w	SelectedW(a5),d0
	mulu	#10,d0
	lea	Prefslist(a5),a0
	move.b	d5,6(A0,d0.w)
	bra.s	.sliPMODEup
.slipmodeG

	lea	Prefslist+6(a5),a0
	moveq	#31-1,d0
.sliPMall
	move.b	d5,(A0)			;Playmode
	add.w	#10,a0
	dbf	d0,.sliPMall
.sliPMODEup
;	bsr	UpdateList		;Spter nur Listview update !!!!
	bsr	MakeLV

	move.b	d5,d0
	bsr	SetPlaymode

	bra	.endit
.noPlmode

	cmp.w	#GD_Surlevel,d4
	bne.s	.nosurlev

	sf	onSurlevslider(A5)
					;d5: -64 <-> 64
	tst.b	onglobal(A5)
	bne.s	.slisurleG

	move.w	SelectedW(a5),d0
	mulu	#10,d0
	lea	Prefslist(a5),a0
	move.b	d5,7(A0,d0.w)
	bra.s	.slisurlevUP
.slisurleG
	lea	Prefslist+7(a5),a0
	moveq	#31-1,d0
.sliSLall
	move.b	d5,(A0)			;Playmode
	add.w	#10,a0
	dbf	d0,.sliSLall
.slisurlevUP
;	bsr	UpdateList		;Spter nur Listview update !!!!
	bsr	MakeLV

	move.w	d5,d0
	bsr	setPrefetch
	bra	.endit
.nosurlev

.endit
.ma
	rts
*****************************************************************************
*                       SliderGadgets auswerten                             *
*****************************************************************************
TestDOWNGadgets
	move.l	4.w,a6

	ifne	V37Gadtools
	moveq	#-1,d0
	else
	cmp.w	#39,lib_version(A6)
	endc

	blt	.endit

	cmp.w	#GD_MixingSlider,d4
	bne.s	.nosli

	st	onmixingslider(A5)
.nosli
	cmp.w	#GD_VBoost,d4
	bne.s	.nosli2

	st	onvboostslider(A5)
.nosli2
	cmp.b	#GD_Playmode,d4
	bne.s	.nosli3

	st	onPlaymodeslider(A5)
.nosli3

	cmp.w	#GD_Surlevel,d4
	bne.s	.nosurlev

	st	onSurlevslider(A5)
.nosurlev

.endit
	rts
UpdateDownGadgets
	move.l	4.w,a6
	cmp.w	#39,lib_version(A6)
	blt	.endit

	tst.b	onmixingslider(A5)
	beq.s	.nosli1
	
	moveq	#GD_MixingSlider,d0
	bsr	_GADR			;Gadgetadresse in A0
	move.l	a0,a1
	bsr	.testup

	move.w	#10,d1
	mulu	d5,d1
	move.w	SelectedW(a5),d0
	mulu	#10,d0
	lea	Prefslist(a5),a0
	move.l	d1,(A0,d0.w)

	bsr	SetRate
	bsr	CalcValues
	bra.w	.rts
.nosli1
	tst.b	onvboostslider(A5)
	beq.s	.nosli2
	
	moveq	#GD_VBoost,d0
	bsr	_GADR			;Gadgetadresse in A0
	move.l	a0,a1
	bsr	.testup

	move.w	SelectedW(a5),d0
	mulu	#10,d0
	lea	Prefslist+4(a5),a0
	move.w	d5,(A0,d0.w)

	bsr	SetVBoost
	bsr	makedivtabs
	bra.s	.rts
.nosli2
	tst.b	onPlaymodeslider(A5)
	beq.s	.nosli3

	moveq	#GD_Playmode,d0
	bsr	_GADR			;Gadgetadresse in A0
	move.l	a0,a1
	bsr	.testup

	move.w	SelectedW(a5),d0
	mulu	#10,d0
	lea	Prefslist+6(a5),a0
	move.b	d5,(A0,d0.w)

	move.b	d5,d0
	bsr	SetPlaymode
	bra.s	.rts
.nosli3
	tst.b	onSurlevslider(A5)
	beq.s	.nosurlev

	moveq	#GD_Surlevel,d0
	bsr	_GADR			;Gadgetadresse in A0
	move.l	a0,a1
	bsr	.testup

	move.w	SelectedW(a5),d0
	mulu	#10,d0
	lea	Prefslist+7(a5),a0
	move.b	d5,(A0,d0.w)

	move.w	d5,d0
	bsr	setPrefetch
	bra.s	.rts
.nosurlev

.endit
	moveq	#0,d0
	rts
.rts
	moveq	#1,d0
	rts
.testup
	movem.l	d1-d4/d6-a6,-(sp)

	move.l	a1,d7
	move.l	_dos(a5),a6
	moveq	#1,d1
	jsr	_LVOdelay(a6)
	move.l	d7,a1

	move.l	a1,a0			;gad
	move.l	gadsave(A5),a6		;lib
	sub.l	a2,a2			;req

	lea	numboo(a5),a1
	lea	mytags(a5),a3		;tags
	move.l	#GTSL_Level,(A3)+
	move.l	a1,(a3)+
	clr.l	(A3)+
	lea	mytags(a5),a3		;tags

	move.l	winhandle(A5),a1	;win

	jsr	_LVOGT_Getgadgetattrsa(A6)

	move.l	numboo(a5),d5

	movem.l	(sp)+,d1-d4/d6-a6
	rts
*****************************************************************************
*                 aktuelle Anzahl von Stimmen selektieren                   *
* Input: d0 = Num Voices                                                    *
*****************************************************************************
SelectEntry:
	movem.l	d0-a6,-(Sp)
	lea	datas,a5

	subq.w	#2,d0
	bpl.s	.hi
	moveq	#0,d0
.hi	move.w	d0,SelectedW(A5)	;aktuell angeclickter Modus
	move	d0,Currentnumvoc(a5)

	bsr	UpdateList

	tst.l	winhandle(A5)
	beq.s	.err

	moveq	#GD_LISTVIEW,d0
	bsr	_GADR			;Gadgetadresse in A0
	lea	mytags(a5),a3
	move.l	#GTLV_Makevisible,(a3)+
	move.l	selectedL(a5),(a3)+
	clr.l	(a3)
	lea	mytags(a5),a3

	move.l	winhandle(A5),a1
	suba.l	a2,a2
	move.l	gadsave(A5),a6
	jsr	_LVOGT_Setgadgetattrsa(A6)
.err
	movem.l	(Sp)+,d0-a6
	rts
*****************************************************************************
*          Einsprung, was alles up to Date gebracht werden mu              *
*****************************************************************************
;;
UpdateList:
	tst.l	winhandle(a5)
	beq.s	.end
	movem.l	d0-a6,-(Sp)

	bsr	MakeLV			;Listview in Ordnung bringen
	bsr	SetVoic
	bsr	SetVBoost
	bsr	SetVBoostSlider
	bsr	SetRate
	bsr	SetLevel
	bsr	SetPlaymodeSlider
	bsr	SetSurlevelSlider
	movem.l	(sp)+,d0-a6
.end
	rts
SetPlaymodeSlider:
	move.w	SelectedW(a5),d0
	mulu	#10,d0
	lea	Prefslist(a5),a0
	move.b	6(A0,d0.w),d1		;Playmode: -64 .. 64
	ext.w	d1
	ext.l	d1

	moveq	#GD_Playmode,d0
	bsr	_GADR			;Gadgetadresse in A0
	lea	mytags(a5),a3
	move.l	#GTSL_Level,(A3)+
	move.l	d1,(a3)+
	clr.l	(A3)+
	bra	SetGAD
SetSurlevelSlider
	move.w	SelectedW(a5),d0
	mulu	#10,d0
	lea	Prefslist(a5),a0
	move.b	7(A0,d0.w),d1		;Playmode: -64 .. 64
	ext.w	d1
	ext.l	d1

	moveq	#GD_Surlevel,d0
	bsr	_GADR			;Gadgetadresse in A0
	lea	mytags(a5),a3
	move.l	#GTSL_Level,(A3)+
	move.l	d1,(a3)+
	clr.l	(A3)+
	bra	SetGAD
SetLevel:
	move.w	SelectedW(a5),d0
	mulu	#10,d0
	lea	Prefslist(a5),a0
	move.l	(A0,d0.w),d1		;Mixrate
	divu	#10,d1
	and.l	#$ffff,d1

	moveq	#GD_MixingSlider,d0
	bsr	_GADR			;Gadgetadresse in A0
	lea	mytags(a5),a3
	move.l	#GTSL_Level,(A3)+
	move.l	d1,(a3)+
	clr.l	(A3)+
	bra	SetGAD
SetRate
	move.w	SelectedW(a5),d0
	mulu	#10,d0
	lea	Prefslist(a5),a0
	move.l	(A0,d0.w),d1

	moveq	#GD_Samplefreq,d0
	bsr	_GADR			;Gadgetadresse in A0
	lea	mytags(a5),a3
	move.l	#GTIN_Number,(A3)+
	move.l	d1,(a3)+
	clr.l	(A3)+
	bra	SetGAD
SetVBoost:
	move.w	SelectedW(a5),d0
	mulu	#10,d0
	lea	Prefslist+4(a5),a0
	moveq	#0,d1
	move.w	(A0,d0.w),d1

	moveq	#GD_NumVBoost,d0
	bsr	_GADR			;Gadgetadresse in A0
	lea	mytags(a5),a3
	move.l	#GTTX_Text,(A3)+
	lea	numboo(a5),a1
	move.l	a1,(a3)+
	clr.l	(A3)+

	divu	#100,d1
	add.b	#` `,d1
	cmp.b	#` `,d1
	beq.s	.set
	add.b	#"0"-" ",d1
.set
	move.b	d1,(a1)+

	clr.w	d1
	swap	d1
	divu	#10,d1
	add.b	#`0`,d1
	move.b	d1,(a1)+

	swap	d1
	move.b	#`.`,(a1)+
	add.b	#`0`,d1
	move.b	d1,(a1)+

	clr.b	(a1)
	bra	SetGAD
SetVBoostSlider
	move.w	SelectedW(a5),d0
	mulu	#10,d0
	lea	Prefslist+4(a5),a0
	moveq	#0,d1
	move.w	(A0,d0.w),d1		;VolBoost

	moveq	#GD_VBoost,d0
	bsr	_GADR			;Gadgetadresse in A0
	lea	mytags(a5),a3
	move.l	#GTSL_Level,(A3)+
	move.l	d1,(a3)+
	clr.l	(A3)+
	bra	SetGAD
SetVoic:
	moveq	#GD_VOICES,d0
	bsr	_GADR			;Gadgetadresse in A0
	lea	mytags(a5),a3
	lea	NumVoc(A5),a1
	move.l	#GTTX_Text,(A3)+
	move.l	a1,(a3)+
	clr.l	(A3)+

	;---------- hier noch test auf Global -------------
	tst.b	onglobal(a5)
	beq.s	.ori

	move.b	#`G`,(a1)+
	clr.b	(a1)
	bra.s	setgad
.ori
	move.l	SelectedL(a5),d0
	addq.l	#2,d0

	divu	#10,d0
	add.b	#"0",d0
	move.b	d0,(a1)+

	swap	d0
	add.b	#`0`,d0	
	move.b	d0,(a1)+

	clr.b	(a1)
SetGAD
	lea	mytags(a5),a3
	move.l	winhandle(A5),a1
	suba.l	a2,a2
	move.l	gadsave(A5),a6
	jsr	_LVOGT_Setgadgetattrsa(A6)
	rts
MakeLV:
	push	all
	move.l	4.w,a6				;nur irgendeine Librarybase bentigt

	tst.l	winhandle(A5)
	beq.w	.lv_rts

	push	d5
	bsr	remlist		;Liste abhngen

	lea	list(a5),a0
	newlist	a0
	lea	Nodes(a5),a4		;1. Node

	move	Currentnumvoc(a5),d5
	moveq	#0,d4
	
	moveq	#31-1,d7
	moveq	#2,d6
	lea	Prefslist(A5),a3
.nodeloop
	lea	list(A5),a0		;gleich nach Alloc anhngen
	move.l	a4,a1			;(erspart Arbeit)
	addtail
	lea	ML_Nodename(a4),a1
	move.l	a1,ln_name(A4)

	cmp	d4,d5
	bne.s	.nosele
	tst.b	onplay
	beq.s	.nosele

	cmp.w	#39,lib_version(a6)
	ifeq	V37Gadtools
	blo.s	.nosele
	else
	bra.s	.nosele
	endc

	move.b	#`|`,(a1)+
.nosele
	addq	#1,d4

	move.w	8(a3),d0		;Flags
	and.b	#1,d0
	beq.s	.nodis
	move.b	#`(`,(a1)+
.nodis
	move.b	#` `,(a1)+

	move.l	d6,d0
	moveq	#2,d1			;Anzahl der Stellen
	bsr	todez
	move.b	#`c`,(a1)+
	move.b	#`h`,(a1)+
	move.b	#`:`,(a1)+
	move.b	#` `,(a1)+

	move.l	(A3)+,d0		;Mixingrate
	moveq	#5,d1			;Anzahl der Stellen
	bsr	todez
	move.b	#` `,(a1)+

	moveq	#0,d0
	move.w	(A3),d0			;Volumeboost
	divu	#10,d0			;durch 100 (wg. Nachkomma)
	and.l	#$fff,d0
	moveq	#2,d1
	bsr	todez
	move.b	#`.`,(a1)+

	clr.l	d0
	move.w	(A3)+,d0		;Volumeboost
	divu	#10,d0	
	swap	d0			;Nachkommastelle
	add.b	#`0`,d0
	move.b	d0,(a1)+
	move.b	#` `,(a1)+

					;A3 steht auf Effektwort
	moveq	#" ",d1
	move.b	(a3)+,d0
	bpl.s	.hi_s
	neg.b	d0
	move.b	#`-`,d1
.hi_S	move.b	d1,(a1)+
	and.l	#$ff,d0
	moveq	#2,d1
	bsr	todez
	move.b	#` `,(a1)+

	move.b	(a3)+,d0
	and.l	#$ff,d0
	moveq	#2,d1
	bsr	todez

	move.b	#` `,(a1)+

	move.w	(a3),d0			;Flags
	and.b	#1,d0
	beq.s	.nodis2
	move.b	#`)`,(a1)+
.nodis2
	clr.b	(a1)

	addq.l	#2,a3

	addq.w	#1,d6
	lea	ML_Sizeof(a4),a4
	dbf	d7,.nodeloop

	pop	d5
	bsr	readdlist
.lv_rts
	pop	all
	rts
***************** Liste vom Listview-Gadget entfernen ****************
Remlist:
	movem.l	d0-a6,-(sp)
	tst.l	winhandle(a5)
	beq.s	.err

	moveq	#GD_LISTVIEW,d0
	bsr	_GADR			;Gadgetadresse in A0
	lea	mytags(a5),a3
	move.l	#GTLV_Labels,(a3)+
	move.l	#-1,(a3)+
	clr.l	(A3)
	lea	mytags(a5),a3

	move.l	winhandle(A5),a1
	suba.l	a2,a2
	move.l	gadsave(A5),a6
	jsr	_LVOGT_Setgadgetattrsa(A6)
.err
	movem.l	(sp)+,d0-a6
	rts
**************** Liste wieder an Gadget anhngen *********************
readdlist:
	movem.l	d0-a6,-(sp)
	tst.l	winhandle(A5)
	beq.s	.err

	moveq	#GD_LISTVIEW,d0
	bsr	_GADR			;Gadgetadresse in A0
	lea	mytags(a5),a3
	move.l	#GTLV_Labels,(a3)+
	lea	list(a5),a2
	move.l	a2,(a3)+
	move.l	#GTLV_Selected,(a3)+
	move.l	selectedL(a5),(a3)+
	clr.l	(A3)
	lea	mytags(a5),a3

	move.l	winhandle(A5),a1
	suba.l	a2,a2
	move.l	gadsave(A5),a6
	jsr	_LVOGT_Setgadgetattrsa(A6)

;	move.l	gadsave(A5),a6
;	move.l	winhandle(a5),a0
;	suba.l	a1,a1
;	jsr	_LVOGT_refreshwindow(A6)
.err
	movem.l	(sp)+,d0-a6
	rts
**************** Hex to decimal ASCII conversion ************************
ToDEZ
	movem.l	d0-a0/a2-a6,-(Sp)
	lea	dectable(pc),a0
	move.w	d1,d2
	lsl.w	#2,d2
	add.w	d2,a0
	subq.w	#1,d1
.loopl
	moveq	#-1,d3
	move.l	-(a0),d2
.loop2l
	addq.b	#1,d3
	sub.l	d2,d0
	bcc.s	.loop2l
	add.l	d2,d0
	add.b	#`0`,d3
	move.b	d3,(a1)+
	dbf	d1,.loopl
	movem.l	(sp)+,d0-a0/a2-a6
	rts
;*****************************************************************************
;*                        Noteplayer-Init/Mix Routinen                       *
;*****************************************************************************
; Init/End
;          - Initplayer -> bergabe A0: Tagliste
;                                   A5: EP Globals
;                       -> zurck   D0: 0=OK, <>0=Error
;
; Start-Stop: Startint (keine bergabeargumente)
;
;             Stopint  (keine bergabeargumente)
;
Init:
	move.l	#EPAMT_Flags,d0
	jsr	ENPP_FindTag(A5)
	beq	.err

	moveq	#1,d2
	move.l	d0,d1
	move.l	d0,d6
	and.l	#EPAMB_WaitForStruct,d6

	and.l	#EPAMB_8Bit,d0
	bne	.ok
	and.l	#EPAMB_8BitUnsigned,d1
	beq	.err
	moveq	#2,d2
.ok
	move.w	d2,fformat

	move.l	#EPAMT_Audiostructs,d0
	jsr	ENPP_FindTag(A5)
	beq	.err
	move.l	d0,d7

	move.l	#EPAMT_NumStructs,d0
	jsr	ENPP_FindTag(A5)
	beq	.err
	move.l	d7,a0

	move	d0,numstructs

	subq.w	#1,d0			;Anzahl der Audio-Strukturen
	blt	.err

	moveq	#0,d1
	moveq	#0,d2
	lea	(a0),a2
.countvoc
	tst.w	AS_LeftRight(a2)
	bpl.s	.addL
	bmi.s	.addR
	bra.s	.noADD
.addL
	cmp.w	#2,AS_Leftright(a2)
	beq	.err
	addq.w	#1,d1
	bra.s	.noADD
.addR
	addq.w	#1,d2
.noadd
	lea	as_sizeof(a2),a2
	dbf	d0,.countvoc

	st	onplay

	move.w	d2,d0
	add.w	d1,d0
	beq	.err			;wie, was, gar nichts ?

	cmp	#32,d0			;mehr als 32 benutzte Stimmen ?
	bhi	.err			;ja, raus

	subq.w	#2,d0
	bgt.s	.hi1
	moveq	#0,d0
.hi1
	mulu	#10,d0
	lea	Prefslist+datas,a1
	lea	(a1,d0.w),a1
	move.l	a1,usedmode
	
	move.w	8(A1),d0		;Flags.w (Bit0=disable)
	and.b	#1,d0
	bne	.err			;Modus disabled !!

	move.w	d1,numleft
	move.w	d2,numright

	move.l	a0,epg_audiostruct(A5)	;Audiostruct setzen
	tst.l	d6			;Flag fr "WaitforStruct" gesetzt ?
	beq.s	.normal
	lea	Extra_AS,a0		;ja, also eigene AS Struktur verwenden
.normal
	move.l	a0,myAudioStruct	;AudioStruct vom Replayer sichern
;	move.l	a0,0

	move.b	6(a1),d0		;Playmode
	bsr	SetPlaymode

	move.b	7(a1),d0
	bsr	setPrefetch

	bsr	InitTables
	bne.s	.err2

	move.w	numleft,d0
	add.w	numright,d0
	bsr	SelectEntry

	bsr	Copy_AS2

	moveq	#0,d0
	rts
.err
	moveq	#-1,d0
.err2
	sf	onplay
	rts

	;-------------------- (noch) keine Funktion -------------------
END:
	clr.b	onplay
	move	#-1,Currentnumvoc+datas		;kein Modul am Spielen

;	move.w	#15,$dff096
;	clr.w	$dff0a8
;	clr.w	$dff0b8
;	clr.w	$dff0c8
;	clr.w	$dff0d8

	bsr	myFreemem

	moveq	#0,d0
	rts

***************************************************************************
*              kopiert neue Audio-Struct auf die eigene AS Struktur rber *
***************************************************************************
Copy_AS:			;mit Umschaltung von dff09a
		push	all
		lea	$dff09a,a6

		tst.b	onplay
		beq.w	.err

		move.l	MYEpBase(pc),a0
		move.l	epg_audiostruct(A0),d0
		beq.w	.err
		move.l	d0,a0			;Original

;		move.l	myAudioStruct(pc),a1	;meine Extra-Struktur
		lea	Extra_AS,a1

		move	numstructs(pc),d0
		subq	#1,d0
		bmi.w	.err

		move	#1<<7,(a6)		;Audio Int verbieten
.all
		move.l	AS_ChangeFlags(a0),d1
		btst	#ASChF_Adr,d1
		beq.s	.noad
		move.l	AS_CurrentAdr(a0),AS_CurrentAdr(a1)
		clr.l	AS_CurrentPos(a1)
		clr.l	AS_CurrentFPos(a1)
		clr.b	AS_NoLoop(a1)
.noad
		btst	#ASChF_Len,d1
		beq.s	.nolen
		move.l	AS_SampleSize(a0),AS_SampleSize(a1)
.nolen
		btst	#ASChF_RepAdr,d1
		beq.s	.norepadr
		move.l	AS_RepeatAdr(a0),AS_Repeatadr(a1)
.norepadr
		btst	#ASChF_RepLen,d1
		beq.s	.noreplen
		move.l	AS_RepeatSize(a0),AS_RepeatSize(a1)
.norepLen
		move.w	AS_Period(a0),AS_Period(a1)
		move.w	AS_LeftVolume(a0),AS_LeftVolume(a1)
		move.w	AS_RightVolume(a0),AS_RightVolume(a1)
		move.w	AS_DmaBit(a0),AS_DmaBit(a1)
		move.w	AS_LeftRight(a0),AS_LeftRight(a1)
		move.b	AS_LoopFlag(a0),AS_LoopFlag(a1)
		clr.l	AS_ChangeFlags(a0)

		lea	AS_Sizeof(a0),a0
		lea	AS_Sizeof(a1),a1
		dbf	d0,.all

		move	#1<<7!$8000,(a6)	;Kram kopiert, also Audio Int wieder an
.err
		pop	all
		rts


Copy_AS2:
		push	all

		tst.b	onplay
		beq.s	.err

		move.l	myAudioStruct(pc),a1	;meine Extra-Struktur

		move.l	MYEpBase(pc),a0
		move.l	epg_audiostruct(A0),d0
		beq.s	.err
		move.l	d0,a0			;Original

		move	numstructs(pc),d0
		subq	#1,d0
		bmi.s	.err

.all
		moveq	#AS_Sizeof-1,d1
.cp		move.b	(a0)+,(a1)+
		dbf	d1,.cp

		dbf	d0,.all
.err
		pop	all
		rts

*************************************************************************
*              Mem fr Tabellen besorgen und Tabellen init              *
*************************************************************************
InitTables:
	movem.l	d1-a6,-(Sp)
	
	move.w	numleft(pc),d1
	cmp.w	numright(pc),d1
	bgt.s	.hi
	move.w	numright(pc),d1
.hi
	move.w	d1,maxchan

	move	#-1,LastBoost

	moveq	#0,d0
	move.l	#256,d2
	subq	#1,d1
.l	add.l	d2,d0
	add.l	#256,d2
	dbf	d1,.l

	move.l	d0,mydivtabsize
	moveq	#MEMF_PUBLIC,d1
	move.l	4.w,a6
	jsr	_LVOallocmem(A6)
	move.l	d0,mydivtab
	beq.b	myFreemem2

	move.l	#66*256,d0
	moveq	#MEMF_PUBLIC,d1
	move.l	4.w,a6
	jsr	_LVOallocmem(A6)
	move.l	d0,vtab
	beq.b	myFreemem2

	add.l	#255,d0
	and.l	#~$ff,d0
	move.l	d0,Vtabaddr

	bsr	makedivtabs
	bsr	Makevoltable

	movem.l	(sp)+,d1-a6
	moveq	#0,d0
	rts
***************************************************************************
*                 Speicher von Divtab / VolTab freigeben                  *
***************************************************************************
myFreemem
	movem.l	d1-a6,-(sp)
myFreemem2
	move.l	4.w,a6

	move.l	vtab(pc),d0
	beq.s	.empty1
	move.l	d0,a1
	move.l	#66*256,d0
	jsr	_LVOfreemem(A6)
.empty1
	move.l	mydivtab(pc),d0
	beq.s	.empty2
	move.l	d0,a1
	move.l	mydivtabsize(pc),d0
	jsr	_LVOfreemem(A6)
.empty2

	clr.l	vtab
	clr.l	mydivtab

	movem.l	(sp)+,d1-a6
	moveq	#-1,d0
	rts
****************************************************************************
*                        Divisionstabellen erzeugen                        *
****************************************************************************
makedivtabs:
	move.b	onplay(pc),d0
	beq.w	.skip

	move.l	usedmode,a0
	move.w	4(a0),d4			;VBoost (auf xx.x bezogen,
						;z.B. 082 fr 8.2) 
	cmp	LastBoost(pc),d4
	beq.w	.skip
	move	d4,LastBoost

	mulu	#15,d4				;auf 2^4 umrechnen wegen
	divu	#10,d4				;asr, siehe unten
	and.l	#$ffff,d4

	lea	divtabs,a1
	moveq	#16-1,d5
.safe
	move.l	a0,(a1)+
	dbf	d5,.safe

	lea	divtabs,a1
	move.l	mydivtab(pc),a0

	move	#255,d6
	moveq	#0,d5
	move	maxchan,d5
	move.l	d5,d3
	move.l	d5,d2

	subq	#1,d5
	move	d5,d1
	lsl.l	#7,d5

	lsl.l	#7,d2

.laa	moveq	#0,d0
	move	d6,d7
	move.l	a0,(a1)+

	move.w	d1,-(sp)
.l	move.l	d0,d1
	add.l	d5,d1
	sub.l	d2,d1

	muls	d4,d1		;VBoost
	divs	d3,d1
	ext.l	d1
	asr.l	#4,d1		;VBoost
	
	cmp	#$7f,d1
	ble.b	.d
	move	#$7f,d1
.d	cmp	#$ff80,d1
	bge.b	.d2
	move	#$80,d1
.d2	move.b	d1,(a0)+
	addq.l	#1,d0
	dbf	d7,.l
	move.w	(sp)+,d1

	add	#256,d6
	sub.l	#$80,d5
	dbf	d1,.laa
.skip
	rts
****************************************************************************
*                        Volume Tabelle erzeugen                           *
****************************************************************************
Makevoltable
	move.l	vtabaddr,a0

	moveq	#0,d3		;volume

	cmp	#1,fformat
	beq.b	signed

;	bra	signed

.lop	moveq	#0,d4		;data
.lap	move	d4,d5
	sub	#$80,d5
	mulu	d3,d5
	asr.l	#6,d5
	add	#$80,d5
	move.b	d5,(a0)+
	addq	#1,d4
	cmp	#256,d4
	bne.b	.lap
	addq	#1,d3
	cmp	#65,d3
	bne.b	.lop
	rts

signed
.lop	moveq	#0,d4		;data
.lap	move.b	d4,d5
	ext	d5
	mulu	d3,d5
	asr.l	#6,d5
	add	#$80,d5
	move.b	d5,(a0)+
	addq	#1,d4
	cmp	#256,d4
	bne.b	.lap
	addq	#1,d3
	cmp	#65,d3
	bne.b	.lop
	rts

Mode_Stereo	=	0
Mode_Mono	=	1
Mode_Surround	=	2
****************************************************************************
*                  Delay setzen fr Surround Modus                         *
* Input: d0 = Wert/10                                                      *
****************************************************************************
setPrefetch:
	mulu	#10,d0
	bne.s	.hi1
	moveq	#4,d0
.hi1
	cmp.w	#samlen-4,d0
	ble.s	.lo
	move.w	#samlen-4,d0
.lo
	move.w	d0,prefetch
	rts
***************************************************************************
*  Abspielmodus festlegen, sprich Auswahl zwischen Mono-Stereo-Surround   *
* Input: D0 - Stereo Basisbreite                                          *
***************************************************************************
SetPlaymode:
	movem.l	d0-a6,-(sp)

	lea	Buffer0a,a0
	lea	Buffer1a,a1
	lea	Buffer1a,a2
	lea	Buffer0a,a3

	lea	copybufStereo000,a4
	move.w	MC68030on+datas,d1
	beq.s	.normalUPS_1
	lea	copybufStereo,a4
.normalUPS_1

	tst.b	d0			;Stereo Wiedergabe
	beq.s	.setit

	lea	Buffer0a,a0
	lea	Buffer1a,a1
	lea	Buffer0a,a2
	lea	Buffer1a,a3

	lea	copybufStereo000,a4
	move.w	MC68030on+datas,d1
	beq.s	.normalUPS_2
	lea	copybufStereo,a4
.normalUPS_2

	tst.b	d0
	bmi.s	.setit			;Mono Wiedergabe

	lea	Buffer0a,a0		;Surround Wiedergabe
	lea	Buffer1a,a1
	lea	Buffer2a,a2
	lea	Buffer3a,a3

	lea	copybufSurround000,a4
	move.w	MC68030on+datas,d1
	beq.s	.normalUPS_3
	lea	copybufSurround,a4
.normalUPS_3

	move.l	a2,SpecialBuffer1	;rechter Kanal nach links
	move.l	a3,SpecialBuffer2	;linker Kanal nach rechts
.setit
	lea	Buffer0,a6
	move.l	a0,(a6)+
	move.l	a1,(a6)+
	move.l	a2,(a6)+
	move.l	a3,(a6)+
	move.l	a4,(a6)+

	tst.b	d0
	bpl.s	.hi
	neg.b	d0
.hi	
	and.w	#127,d0
	move.w	d0,effectvol

	lea	myupsstruct,a6
	lea	Buffer0a,a4

	move.l	a4,a5
	move.w	MC68030on+datas,d1
	beq.s	.normalUPS
	lea	UPSBuffer0a,a5
.normalUPS
	move.l	a5,d2

	lea	UPSBuffer0,a5

	move.l	a0,d1
	sub.l	a4,d1
	add.l	d2,d1
	move.l	d1,(a5)+
	move.l	d1,ups_voice1adr(A6)
	move.l	a1,d1
	sub.l	a4,d1
	add.l	d2,d1
	move.l	d1,(a5)+
	move.l	d1,ups_voice2adr(A6)
	move.l	a2,d1
	sub.l	a4,d1
	add.l	d2,d1
	move.l	d1,(a5)+
	move.l	d1,ups_voice3adr(A6)
	move.l	a3,d1
	sub.l	a4,d1
	add.l	d2,d1
	move.l	d1,(a5)+
	move.l	d1,ups_voice4adr(A6)

	move.w	#64,ups_voice1vol(a6)
	move.w	#64,ups_voice2vol(a6)
	move.w	d0,ups_voice3vol(a6)
	move.w	d0,ups_voice4vol(a6)

	clr.l	tmpvol
	clr.w	tmpvol2

	movem.l	(sp)+,d0-a6
	rts

;------------------ Routinen fr den FastRamPlayer -----------------------
StartINT:
	push	d1-a6

	lea	OLDINT0(pc),a0
	move.l	#-1,(a0)

;-------------------- hier alloc Audio -------------------------
	jsr	ENPP_AllocAmigaAudio(a5)
	tst.l	d0
	bne	fail$
;---------------------------------------------------------------
	bset	#1,$bfe001
	move.l	MyEPBase(pc),a0
	tst.b	DTG_LED(a0)
	beq.s	.off
	bclr	#1,$bfe001
.off
					;Audio Interrupt disable
	move.w	#$780,$dff09c		;Interrupt Request Hardwarehack

	movem.l	d0-a6,-(sp)		;Audio Interrupt handler durch
					;eigene ersetzen
	move.l	4,a6
	lea	Aud0Interrupt(pc),a1
	moveq	#7,d0
	jsr	-162(a6)			;Setintvektor
	move.l	d0,Oldint0

	movem.l	(sp)+,d0-a6

	move.w	#$8080,$dff09a			;Interrupt Enable Hardwarehack

	bsr	StartDMA

	lea	myupsstruct,a1
	move.w	#UPSB_Adr!UPSB_LEN!UPSB_Per!UPSB_Vol!UPSB_DMACON,ups_flags(a1)
	move.w	#15,UPS_DmaCon(a1)
	clr.w	UPS_Enabled(a1)

	move.w	#64,ups_voice1vol(a1)
	move.w	#64,ups_voice2vol(a1)
	move	effectvol(pc),d0
	move.w	d0,ups_voice3vol(a1)
	move.w	d0,ups_voice4vol(a1)
	clr.l	tmpvol
	clr.w	tmpvol2

	move.l	newmixingperiod(pc),d0
	move.w	d0,ups_voice1per(a1)
	move.w	d0,ups_voice2per(a1)
	move.w	d0,ups_voice3per(a1)
	move.w	d0,ups_voice4per(a1)

	move.w	#SAMLEN*NumChipBuffers,ups_voice1len(A1)
	move.w	#SAMLEN*NumChipBuffers,ups_voice2len(A1)
	move.w	#SAMLEN*NumChipBuffers,ups_voice3len(A1)
	move.w	#SAMLEN*NumChipBuffers,ups_voice4len(A1)

;	move.l	Buffer0,a0
;	move.l	a0,ups_voice1adr(A1)
;	move.l	Buffer1,a0
;	move.l	a0,ups_voice2adr(A1)
;	move.l	Buffer2,a0
;	move.l	a0,ups_voice3adr(A1)
;	move.l	Buffer3,a0
;	move.l	a0,ups_voice4adr(A1)

	lea	myupsstruct,a6
	movem.l	UPSBuffer0(pc),d3-d6
	move.l	d3,ups_voice1adr(A6)
	move.l	d4,ups_voice2adr(A6)
	move.l	d5,ups_voice3adr(A6)
	move.l	d6,ups_voice4adr(A6)

	moveq	#0,d0
fail$
	pop	d1-a6
	rts
StopINT:
	lea	$dff0a8,a0
	clr.w	(a0)
	clr.w	$10(a0)
	clr.w	$20(a0)
	clr.w	$30(a0)

	jsr	ENPP_FreeAmigaAudio(a5)

	move.l	Oldint0(pc),d0
	cmp.l	#-1,d0
	beq.s	.empty

	move.w	#$780,$dff09a
	move.w	#$780,$dff09c

	move.w	#$f,$dff096			;DMA Stoppen

	move.l	4,a6
	move.l	Oldint0(pc),a1
	moveq	#7,d0
	jsr	-162(a6)			;Setintvektor

	move.w	#$780,$dff09a

	moveq	#-1,d0
	move.l	d0,OldInt0

	moveq	#0,d0
.empty
	rts
;============ Puffer lschen und DMA starten =============================
StartDMA:
	move.w	#$f,$dff096		;DMA Stop

	lea	Buffer0a,a0
	move.w	#[ENDBUFFER-Buffer0a]/2-1,d0
.clr
	clr.w	(A0)+
	dbf	d0,.clr

	lea	StartBSSBuffer,a0
	move.w	#[ENDBSSBUFFER-StartBSSBuffer]/2-1,d0
.clr2
	clr.w	(a0)+
	dbf	d0,.clr2

	bsr	CalcValues
	clr.l	tmpvol
	clr.w	tmpvol2
	clr.l	calcvol
	clr.l	calcvol+4
	move.b	#2,waitstart
	
	move.l	newmixingperiod(pc),mixingperiod

					;Anfangsadressen setzen
	move.w	#$ff,$dff09e		;Modulierungen aller Art aus !
		
	lea	$dff0a0,a5
	move.w	#SamLEN,d0
	move.l	#SAMLEN*2,Lastbuffer

	move.l	mixingperiod(pc),d1

	move.l	Buffer0,a0
	move.l	a0,(a5)
	move.w	d0,4(A5)
	move.w	d1,6(a5)
	clr.w	8(A5)

	lea	$10(a5),a5
	move.l	Buffer1,a0
	move.l	a0,(a5)
	move.w	d0,4(A5)
	move.w	d1,6(a5)
	clr.w	8(A5)

	lea	$10(a5),a5	
	move.l	Buffer2,a0
	move.l	a0,(a5)
	move.w	d0,4(A5)
	move.w	d1,6(a5)
	clr.w	8(A5)

	lea	$10(a5),a5	
	move.l	Buffer3,a0
	move.l	a0,(a5)
	move.w	d0,4(A5)
	move.w	d1,6(a5)
	clr.w	8(A5)

	bsr	CH_DMAWait		;warten bis DMA wirklich gestoppt
	move.w	#$800f,$dff096		;DMA Start
CH_DMAWait
	movem.l	d0/d1,-(SP)
	moveq	#16,d0
.wart2
	move.b	$dff006,d1
.wart
	cmp.b	$dff006,d1
	beq	.wart
	dbf	d0,.wart2
	movem.l	(sp)+,d0/d1
	rts
CalcValues:
;	move.l	#46000,d7			;Samplingrate

	move.b	onplay(pc),d0
	beq.s	skipcalc

	move.l	usedmode,a0
	move.l	(a0),d7
	move.l	d7,playmixrate
CalcnewmixingPeriod:
	move.l	#14187580/4,clock		;Clock constant

	move.l	audiorate(pc),d2

	move.l	d2,d0
	move.l	d7,d1				;mixingrate(pc),d1
	divu	d1,d0
	move.l	d2,d1
	divu	d0,d1
	swap	d1
	clr	d1
	swap	d1
	move.l	d1,mrate

	move.l	d2,d0
	divu	d1,d0
	swap	d0
	clr	d0
	swap	d0
	move.l	d0,newmixingperiod

	push	a1
	lea	myupsstruct,a1
	move.w	d0,ups_voice1per(a1)
	move.w	d0,ups_voice2per(a1)
	move.w	d0,ups_voice3per(a1)
	move.w	d0,ups_voice4per(a1)
	pop	a1
skipcalc

	rts
;=========================================================================
INT_AUD:
	movem.l d0-a6,-(sp)
	move.l	MyEPBase(pc),a5

	move.w	#1<<7,$dff09c			;Interrupt Request Rcksetzen

	move.l	Lastbuffer(pc),d0
	if	NumChipBuffers=2
	eor.l	#SAMLEN*2,d0			;128 Worte
	else
	add.l	#SAMLEN*2,d0
	cmp.l	#SAMLEN*2*NumChipBuffers,d0
	blo.s	.lo
	moveq	#0,d0
.lo
	endc
	move.l	d0,LastBuffer

	lea	$dff0a0,a1
	movem.l	Buffer0(pc),d3-d6
	add.l	d0,d3
	move.l	d3,(a1)
	add.l	d0,d4
	move.l	d4,$10(a1)
	add.l	d0,d5
	move.l	d5,$20(a1)
	add.l	d0,d6
	move.l	d6,$30(a1)

.int
;	move.w	#$f0f,$dff180

	move.l	4.w,a6
	lea	Int_loopStruct,a1
	cmp.b	#NT_Interrupt,ln_type(a1)
	bne.s	.skip

	jsr	-180(a6)	;_LVOcause

;	move.w	#$f00,$dff180
	movem.l	(sp)+,d0-a6
	rts
.skip
;-- Typ der Struktur ist NT_Softint, somit kommt der Prozessor beim Mixen nicht
;-- hinterher -> Mixrate verringern

	move.l	playmixrate(pc),d7
	sub.l	#6000,d7
	cmp.l	#4000,d7
	bge.s	.ok
	move.l	#3800,d7
.ok
	move.l	d7,playmixrate
	bsr	CalcnewmixingPeriod
	move.l	newmixingperiod(pc),mixingperiod

;	move.w	#$f00,$dff180
	movem.l	(sp)+,d0-a6
	rts

;bla1	dc.l	bla

;----------------------------------------------------------------------------------------------------
;--------------------------- setzt Lautstrke, Lnge, Period neu ------------------------------------
;----------------------------------------------------------------------------------------------------
SetHardWare:
		move	#Samlen,d7
		lea	$dff0a0,a1

		move.w	#$800f,$dff096-$dff0a0(a1)	;DMA richtig setzen

		move	d7,4(a1)
		move	d7,$10+4(a1)
		move	d7,$20+4(a1)
		move	d7,$30+4(a1)
	
		move.l	newmixingperiod(pc),d1
		move.l	d1,mixingperiod
		move.w	d1,6(a1)
		move.w	d1,6+$10(a1)
		move.w	d1,6+$20(a1)
		move.w	d1,6+$30(a1)
	
		move.l	MyEPBase(pc),a5
		move.l	dtg_SndVol(A5),d0	; dtg_SndVol & dtg_SndLBal
		move.w	dtg_SndRBal(A5),d1	; dtg_SndVol & dtg_SndLBal
	
		cmp.w	tmpvol2(pc),d1
		bne.s	newvol$
		cmp.l	tmpvol(pc),d0
		beq.s	weiter$
newvol$
		move.b	waitstart(pc),d2
		bmi	ok$
		subq.b	#1,d2
		move.b	d2,waitstart
		bra	weiter$
ok$
		move.l	d0,tmpvol
		move.w	d1,tmpvol2

		move.w	DTG_SndLBal(a5),d0
		mulu	DTG_SndVol(a5),d0
		lsr.w	#6,d0				; durch 64

		move.w	DTG_SndRBal(a5),d1
		mulu	DTG_SndVol(a5),d1
		lsr.w	#6,d1				; durch 64

		move	d1,d2
		mulu	effectvol(pc),d2
		lsr.w	#6,d2

		move	d0,d3
		mulu	effectvol(pc),d3
		lsr.w	#6,d3

		movem.w	d0-d3,calcvol
		bra.s	weiter2$
weiter$		movem.w	calcvol(pc),d0-d3
weiter2$	move.w	d0,8(A1)
		move.w	d1,8+$10(A1)
		move.w	d2,8+$20(A1)		;!!
		move.w	d3,8+$30(A1)		;!!
		rts
;----------------------------------------------------------------------------------------------------
;------------------------------- Mixroutine Main Loop -----------------------------------------------
;----------------------------------------------------------------------------------------------------
DoMix:
	movem.l	d0-a6,-(Sp)
	bsr	SetHardware

;	move.w	#$ff0,$dff180

;	move.l	MyEPBase(pc),a5
;	move.l	epg_audiostruct(A5),a4			;Audiostruct setzen
	move.l	myaudiostruct(pc),a4

;		move.l	#bla,0
;		lea	Extra_as+as_sizeof*3,a0
;		move.l	bla1,a1
;		move.l	as_CurrentAdr+as_sizeof*3(a4),(a1)+
;		move.l	as_Samplesize+as_sizeof*3(a4),(a1)+
;		move.l	a1,bla1


;	lea	as_sizeof*2(a4),a2
;	move.l	a2,0

	move	numstructs,d7
	subq.w	#1,d7
	blt.w	.noleft
	
	move.l	mixad1,a1
	lea	TempBuffer,a2
.loo
	tst.w	AS_LeftRight(a4)
	ble.s	.n
	movem.l	a1/a2/a4/d7,-(sp)
	ifne	benchmark2
	move.w	#$ff0,$dff180
	jsr	(a1)				; Mix
	move.w	#$000,$dff180
	else
	jsr	(a1)
	endc
	movem.l	(sp)+,a1/a2/a4/d7
	move	#1,chans
	lea	AS_Sizeof(a4),a4
	subq	#1,d7
	bra.b	.loo2

.n	lea	AS_Sizeof(a4),a4
	dbf	d7,.loo
	bra.b	.ddq

.loo2	cmp	#1,numleft
	beq.b	.ddq

	move.l	mixad2,a1
.loka	tst.w	AS_LeftRight(a4)
	ble.s	.n2

	movem.l	a1/a2/a4/d7,-(sp)
	jsr	(a1)
	movem.l	(sp)+,a1/a2/a4/d7
	
.n2	lea	AS_Sizeof(a4),a4
	dbf	d7,.loka

.ddq	lea	Tempbuffer,a0

	move.l	LastBuffer(pc),d0
	move.l	Buffer0,a1			;move.l	buff1(a5),a1
	add.l	d0,a1
	move.l	UPSBuffer0,a5			;move.l	buff1(a5),a1
	add.l	d0,a5

	move.l	SpecialBuffer1,a4		;nur fr Surround & 14 Bit
	move.l	UPSBuffer2,a6			;nur fr Surround & 14 Bit
	add.l	d0,a4
	add.l	d0,a6

	move.l	cbufad,a2
	lea	TBufLeft,a3

	move.b	Begin+OnMonoMode(pc),d0
	beq.s	.work
	move	prefetch(pc),d7
	move	d7,d0
	sub	#60,d0
	bgt.s	.work_1
	moveq	#4,d0
.work_1
	move	d0,prefetch
	move.l	d7,-(sp)
	jsr	(a2)
	move.l	(sp)+,d7
	move	d7,prefetch
	bra.s	.noleft
.work
	jsr	(a2)
.noleft

right:
;	move.l	MyEPBase(pc),a5
;	move.l	epg_audiostruct(A5),a4			;Audiostruct setzen
	move.l	myaudiostruct(pc),a4

	move	numstructs,d7
	subq.w	#1,d7
	blt.w	.noright
	
	move.l	mixad1,a1
	lea	TempBuffer2,a2
.loo	tst.w	AS_LeftRight(a4)
	bge.s	.n

	movem.l	a1/a2/a4/d7,-(sp)
	jsr	(a1)
	movem.l	(sp)+,a1/a2/a4/d7
	move	#1,chans
	lea	AS_Sizeof(a4),a4
	subq	#1,d7
	bra.b	.loo2

.n	lea	AS_Sizeof(a4),a4
	dbf	d7,.loo
	bra.b	.ddq

.loo2	cmp	#1,numright
	beq.b	.ddq

	ifne	benchmark2
	lea	mix3,a1
	else
	move.l	mixad2,a1
	endc

.loka	tst.w	AS_LeftRight(a4)
	bge.s	.n2

	movem.l	a1/a2/a4/d7,-(sp)
	ifne	benchmark2
	move.w	#$00f,$dff180
	jsr	(a1)				; Mix
	move.w	#$000,$dff180
	else
	jsr	(a1)
	endc
	movem.l	(sp)+,a1/a2/a4/d7
	
.n2	lea	AS_Sizeof(a4),a4
	dbf	d7,.loka

.ddq	lea	Tempbuffer2,a0

	move.l	LastBuffer(pc),d0
	move.l	Buffer1,a1			;move.l	buff1(a5),a1
	add.l	d0,a1
	move.l	UPSBuffer1,a5			;move.l	buff1(a5),a1
	add.l	d0,a5

	move.l	SpecialBuffer2,a4		;nur fr Surround & 14 Bit
	move.l	UPSBuffer3,a6			;nur fr Surround & 14 Bit
	add.l	d0,a4
	add.l	d0,a6

	move.l	cbufad,a2
	lea	TBufRight,a3

	ifne	benchmark
	bsr	copybufSurroundold
	else
	jsr	(a2)
	endc
.noright
	bsr	CopyASBack
	movem.l	(sp)+,d0-a6
	moveq	#0,d0
	rts
;-----------------------------------------------------------------------------------------------------
CopyASBack:
		move.l	myAudioStruct(pc),d0
		cmp.l	#Extra_AS,d0
		bne.s	.out
		move.l	d0,a0

		move.l	MYEpBase(pc),a1
		move.l	epg_audiostruct(A1),d0
		beq.w	.out
		move.l	d0,a1

		move	numStructs(pc),d0
		subq	#1,d0
.cp
		movem.l	(a0)+,d1-d7/a2-a6	;7+5 Register = 12*4=48 Bytes
		movem.l	d1-d7/a2-a6,(a1)
		lea	12*4(a1),a1
		movem.l	(a0)+,d1-d7/a2-a6	;7+5 Register = 12*4=48 Bytes
		movem.l	d1-d7/a2-a6,(a1)
		lea	12*4(a1),a1
		move.l	(a0)+,(a1)+
		dbf	d0,.cp
.out
		rts
;-----------------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------------
;--------------------------------- 8 Bit Mixing Routine (Part1 - Move Data) --------------------------
;-----------------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------------
mix:
	moveq	#0,d7
	move	#samlen*2,d7

	tst	AS_Period(A4)
	beq	.ty

	tst.b	AS_NoLoop(a4)
	bne	.ty			;noloop

	tst.b	AS_DmaBit(a4)
	beq	.ty			;noloop

	tst.l	AS_Currentadr(a4)	;pos (addr)
	bne.s	.dw

	clr.l	AS_CurrentPos(a4)
	move.l	AS_RepeatAdr(A4),AS_CurrentAdr(a4)
	beq	.ty
	move.l	AS_RepeatSize(a4),AS_SampleSize(a4)
	beq	.ty

.dw	move.l	clock(pc),d4
	move.w	AS_Period(a4),d0
;	lsl	#2,d0
	divu	d0,d4			;period
	swap	d4
	clr	d4
	lsr.l	#2,d4

	move.l	mrate(pc),d0
	divu	d0,d4
	swap	d4
	clr	d4
	rol.l	#4,d4

	move.l	vtabaddr,d2
	moveq	#0,d0
	move	AS_LeftVolume(a4),d0	;2 b changed 4 panning support

	lsl.l	#8,d0
	add.l	d0,d2				; Position in volume table

	move.l	AS_Currentadr(a4),a0	;pos (addr)
	move.l	AS_CurrentPos(a4),d6
	add.l	d6,a0			;aktuelle Position + dem schon gespielten

	moveq	#0,d0
	move.w	AS_CurrentFPOS(a4),d0	;fpos
	swap	d0			;nach oben

	moveq	#0,d3
	moveq	#0,d5

	move.l	d4,d1			;Counter fr Zoom
	swap	d1			;count bis zum nchsten Byte
	lsl.l	#3,d1			;Mal 8 (wg. 8 * Mix)
	swap	d1			;Overflow count, also wieviele neue Bytes zu holen sind
	move.l	d1,a1

	btst	#ASLoopF_BackLooping,AS_CurrentFPOS+2(a4)
	bne.w	.Ping_Init

	neg.l	d6			;
	add.l	AS_SampleSize(a4),d6	;Gesamtlnge + (- gespielte Lnge) = brige Lnge
	bpl.s	.Checkd6
	move.l	AS_SampleSize(a4),d6	;Gesamtlnge + (- gespielte Lnge) = brige Lnge
	move.l	AS_Currentadr(a4),a0	;pos (addr)
.Checkd6
	cmp.l	#$7fff,d6
	bls.s	.ok
	move.l	#$7fff,d6
.ok

.leii	subq	#8,d7
	blt.s	.lep

	move.l	a1,d1			;aktuell
	add.l	d0,d1			;+ aktuelle Position, wieviele Bytes schon weg sind
	addx	d5,d1
	cmp	d6,d1			;grer als brige Bytes ?
	bhs.s	.lep			;yup

	rept	4
	move.b	(a0,d0),d2
	move.l	d2,a3
	add.l	d4,d0
	move.b	(a3),d3
	addx	d5,d0
	swap	d3
	move.b	(a0,d0),d2
	move.l	d2,a3
	add.l	d4,d0
	move.b	(a3),d3
	addx	d5,d0
	move.l	d3,(a2)+
	endr

	bra.s	.leii
.lep	addq	#8,d7
	beq.w	.qw
	subq	#1,d7
.lep2
	move.b	(a0,d0),d2
	move.l	d2,a3
	add.l	d4,d0
	move.b	(a3),d3
	move	d3,(a2)+
	addx	d5,d0

	cmp	d6,d0
	bhs.b	.ddwq
	dbf	d7,.lep2
	bra.w	.qw
.ddwq
	move.b	AS_LoopFlag(a4),d1
	bne.b	.q
	st	AS_NoLoop(a4)
;	subq	#1,d7
	bra.w	.ty
.q

;	bpl.s	.noneg				;wenn gerade rckwrts gelooped wurde, dann den
;						;Unterlaufbertrag umkehren
;	neg.w	d0
;.noneg
	addq	#1,d7

	btst	#ASLoopF_PingPong,d1
	bne.s	.PingPongLoop
.NormalLoop
	bset	#ASLoopF_Looping,AS_CurrentFPOS+2(a4)

	move.l	AS_RepeatAdr(a4),a0		;loop start
	move.l	a0,AS_CurrentAdr(a4)

	moveq	#0,d1
	move.w	d0,d1				;im aktuellen Rundlauf gespielte Lnge
	add.l	AS_CurrentPos(a4),d1
	sub.l	AS_Samplesize(A4),d1
	move.l	d1,AS_CurrentPos(a4)
	add.l	d1,a0

	move.l	AS_RepeatSize(a4),d6		;loop len
	move.l	d6,AS_SampleSize(a4)
	sub.l	d1,d6				;Len - Current Position
	clr	d0				;reset integer part

	tst.l	AS_Int(a4)		;"Interrupt" bei neuem Sample ?
	beq.s	.noInt
	movem.l	d0-a6,-(sp)		;nur zur Sicherheit
	move.l	AS_Int(A4),a1
	move.l	4.w,a6
	jsr	_LVOCause(a6)
	movem.l	(sp)+,d0-a6		;man weiss ja nie...
.noINT
	dbf	d7,.checkd6	;max. Samplesize is bigger >64k !!
	bra.s	.qw
.PingPongLoop
	btst	#ASLoopF_Looping,AS_CurrentFPOS+2(a4)
	beq.s	.NormalLoop

	bset	#ASLoopF_BackLooping,AS_CurrentFPOS+2(a4)

	move.l	AS_RepeatAdr(a4),a0		;loop start
	move.l	a0,AS_CurrentAdr(a4)

	moveq	#0,d1
	move.w	d0,d1				;im aktuellen Rundlauf gespielte Lnge
	add.l	AS_CurrentPos(a4),d1
	sub.l	AS_Samplesize(A4),d1		;bertrag ber eigentliche aktuelle Lnge

	move.l	AS_Repeatsize(a4),d6
	move.l	d6,AS_Samplesize(a4)
	sub.l	d1,d6
	subq.l	#1,d6
	move.l	d6,AS_CurrentPos(a4)		;aktuelle Position = Repeatsize-1-bertrag
	add.l	d6,a0				;Aktuelle Position
	clr	d0				;reset integer part

	tst.l	AS_Int(a4)		;"Interrupt" bei neuem Sample ?
	beq.s	.noInt_P
	movem.l	d0-a6,-(sp)		;nur zur Sicherheit
	move.l	AS_Int(A4),a1
	move.l	4.w,a6
	jsr	_LVOCause(a6)
	movem.l	(sp)+,d0-a6		;man weiss ja nie...
.noINT_P
	dbf	d7,.Ping_Init2
.qw
	moveq	#0,d6
	move	d0,d6
	add.l	AS_CurrentPos(a4),d6
	move.l	d6,AS_CurrentPos(a4)

	swap	d0
	move.w	d0,AS_CurrentFPOS(a4)	;Fraction Pos

	sub.l	AS_SampleSize(a4),d6
	blt.s	.u

	move.b	AS_LoopFlag(a4),d1
	bne.b	.q2
	st	AS_NoLoop(a4)			; sample is not looping
	bra.b	.u

.q2
	bset	#ASLoopF_Looping,AS_CurrentFPOS+2(a4)

	move.l	AS_RepeatSize(a4),a0		;loop len
	move.l	a0,AS_RepeatSize(a4)
	move.l	AS_Repeatadr(a4),a0
	move.l	A0,AS_CurrentAdr(a4)

	move.l	d6,AS_CurrentPos(a4)

	tst.l	AS_Int(a4)		;"Interrupt" bei neuem Sample ?
	beq.s	.noInt1
	movem.l	d0-a6,-(sp)		;nur zur Sicherheit
	move.l	AS_Int(A4),a1
	move.l	4.w,a6
	jsr	_LVOCause(a6)
	movem.l	(sp)+,d0-a6		;man weiss ja nie...
.noINT1
.u	rts

.ty	move	#$80,d0
	tst	d7
	bmi.b	.e
.lll	move	d0,(a2)+
	dbf	d7,.lll
.e	rts

.Ping_Init
.Ping_Init2
		neg.w	d4		;rckwrts zhlen bei Mixrate < originale Samplerate 
					;in D6 brige Lnge (currentPos = Rest vom aktuellen
					;Wert bis 0)
		move.l	a1,d1
		neg.w	d1
		move.l	d1,a1
.Ping_checkd6
		cmp.l	#$7fff,d6
		bls.s	.Ping_ok
		move.l	#$7fff,d6
.Ping_ok

.Ping_leii
		subq	#8,d7
		blt.s	.Ping_lep

		move.l	a1,d1			;Anzahl zu holender Bytes bei 8 Mixdurchlufen
		add.l	d0,d1			;+ aktuelle Position, wieviele Bytes schon weg sind
		add	d6,d1			;grer als brige Bytes ?
		ble.s	.Ping_lep		;yup

		rept	4
		move.b	(a0,d0.w),d2
		move.l	d2,a3
		add.l	d4,d0			;+(-Fraction)
		move.b	(a3),d3
		subx	d5,d0
		swap	d3
		move.b	(a0,d0.w),d2
		move.l	d2,a3
		add.l	d4,d0
		move.b	(a3),d3
		subx	d5,d0
		move.l	d3,(a2)+
		endr

		bra.w	.Ping_leii
.Ping_lep	addq	#8,d7
		beq.w	.Ping_qw
		subq	#1,d7
.Ping_lep2
		move.b	(a0,d0.w),d2
		move.l	d2,a3
		add.l	d4,d0
		move.b	(a3),d3
		move	d3,(a2)+
		subx	d5,d0

		move	d0,d1
		add	d6,d1
		ble.s	.Ping_ddwq

		dbf	d7,.Ping_lep2
		bra.s	.Ping_qw
.Ping_ddwq
;		move.b	AS_LoopFlag(a4),d1
;		bne.b	.q
;		st	AS_NoLoop(a4)
;		bra.w	.ty
;.q

;weil gerade rckwrts gelooped wurde, gehts nun in jedem Fall vorwrts weiter

		addq	#1,d7

		neg.w	d0		;|gespielte Lnge| (fr bertrag)

		bclr	#ASLoopF_BackLooping,AS_CurrentFPOS+2(a4)

		move.l	AS_RepeatAdr(a4),a0		;loop start
		move.l	a0,AS_CurrentAdr(a4)

		moveq	#0,d1
		move.w	d0,d1				;im aktuellen Rundlauf gespielte Lnge
		sub.l	AS_CurrentPos(a4),d1
		move.l	d1,AS_CurrentPos(a4)
		add.l	d1,a0

		move.l	AS_RepeatSize(a4),d6		;loop len
		move.l	d6,AS_SampleSize(a4)
		sub.l	d1,d6				;Len - Current Position
		clr	d0				;reset integer part

		tst.l	AS_Int(a4)		;"Interrupt" bei neuem Sample ?
		beq.s	.Ping_noInt
		movem.l	d0-a6,-(sp)		;nur zur Sicherheit
		move.l	AS_Int(A4),a1
		move.l	4.w,a6
		jsr	_LVOCause(a6)
		movem.l	(sp)+,d0-a6		;man weiss ja nie...
.Ping_noINT
		neg.w	d4		;rckwrts zhlen bei Mixrate < originale Samplerate 
					;in D6 brige Lnge (currentPos = Rest vom aktuellen
					;Wert bis 0)

		move.l	a1,d1
		neg.w	d1
		move.l	d1,a1

		dbf	d7,.checkd6	;max. Samplesize is bigger >64k !!

		swap	d0
		move	d0,AS_CurrentFPOS(a4)	;Fraction Pos
		bra.s	.Ping_U
.Ping_qw
		neg.w	d0		;|gespielte Lnge| (fr bertrag)

		moveq	#0,d1
		move	d0,d1

		swap	d0
		move.w	d0,AS_CurrentFPOS(a4)	;Fraction Pos

		move.l	AS_CurrentPos(a4),d6
		sub.l	d1,d6
		move.l	d6,AS_CurrentPos(a4)
		bgt.s	.Ping_U

		bclr	#ASLoopF_BackLooping,AS_CurrentFPOS+2(a4)

		move.l	AS_RepeatAdr(a4),a0		;loop start
		move.l	a0,AS_CurrentAdr(a4)

		neg.l	d6
		move.l	d6,AS_CurrentPos(A4)

		move.l	AS_RepeatSize(a4),d6		;loop len
		move.l	d6,AS_SampleSize(a4)

		tst.l	AS_Int(a4)		;"Interrupt" bei neuem Sample ?
		beq.s	.Ping_noInt1
		movem.l	d0-a6,-(sp)		;nur zur Sicherheit
		move.l	AS_Int(A4),a1
		move.l	4.w,a6
		jsr	_LVOCause(a6)
		movem.l	(sp)+,d0-a6		;man weiss ja nie...
.Ping_noINT1
.Ping_u		rts


;-----------------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------------
;--------------------------------- 8 Bit Mixing Routine (Part2 - Add Data) ---------------------------
;-----------------------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------------------
mix2:
	moveq	#0,d7
	move	#samlen*2,d7
	
;	cmp.w	#34*4,AS_Period(a4)
;	blo	.ty

	tst.w	AS_Period(a4)
	beq	.ty


	tst.b	AS_NoLoop(a4)
	bne	.ty			;noloop

	tst.b	AS_DmaBit(a4)
	beq	.ty			;noloop

	tst.l	AS_Currentadr(a4)	;pos (addr)
	bne.s	.dw

	clr.l	AS_CurrentPos(a4)
	move.l	AS_RepeatAdr(A4),AS_CurrentAdr(a4)
	beq	.ty
	move.l	AS_RepeatSize(a4),AS_SampleSize(a4)
	beq	.ty
.dw
	move.l	clock(pc),d4
	move.w	AS_Period(a4),d0
;	lsl	#2,d0
	divu	d0,d4			;period
	swap	d4
	clr	d4
	lsr.l	#2,d4

	move.l	mrate(pc),d0
	divu	d0,d4
	swap	d4
	clr	d4
	rol.l	#4,d4

	move.l	vtabaddr,d2
	moveq	#0,d0
	move	AS_LeftVolume(a4),d0

;	mulu	PS3M_master(a5),d0
;	lsr	#6,d0

	lsl.l	#8,d0
	add.l	d0,d2				; Position in volume table

	move.l	AS_Currentadr(a4),a0	;pos (addr)
	move.l	AS_CurrentPos(a4),d6
	add.l	d6,a0			;aktuelle Position + dem schon gespielten

	moveq	#0,d0
	move.w	AS_CurrentFPOS(a4),d0	;fpos
	swap	d0

	moveq	#0,d3
	moveq	#0,d5

	move.l	d4,d1			;Counter fr Zoom
	swap	d1			;count bis zum nchsten Byte
	lsl.l	#3,d1			;Mal 8 (wg. 8 * Mix)
	swap	d1			;Overflow count, also wieviele neue Bytes zu holen sind
	move.l	d1,a1

	btst	#ASLoopF_BackLooping,AS_CurrentFPOS+2(a4)
	bne.w	.Ping_Init

	neg.l	d6
	add.l	AS_SampleSize(a4),d6	;Gesamtlnge + (- gespielte Lnge)
	bge.s	.Checkd6
	move.l	AS_SampleSize(a4),d6	;Gesamtlnge + (- gespielte Lnge) = brige Lnge
	move.l	AS_Currentadr(a4),a0	;pos (addr)
.Checkd6
	cmp.l	#$7fff,d6
	bls.s	.ok
	move.l	#$7fff,d6
.ok

.leii	subq	#8,d7
	blt.s	.lep
;	bra.s	.lep			;testhalber...

	move.l	a1,d1
	add.l	d0,d1			;+ aktuelle Position, wieviele Bytes schon weg sind
	addx	d5,d1
	cmp	d6,d1			;grer als brige Bytes ?
	bhs.s	.lep			;yup

	rept	8
	move.b	(a0,d0),d2
	move.l	d2,a3
	move.b	(a3),d3
	add.l	d4,d0
	addx	d5,d0
	add	d3,(a2)+
	endr
	bra.w	.leii
.lep	addq	#8,d7
	beq.w	.qw
	subq	#1,d7			;wg. dbf

;	cmp	d6,d0
;	bhs.b	.ddwq
.lep2
	move.b	(a0,d0),d2
	move.l	d2,a3
	add.l	d4,d0
	move.b	(a3),d3
	addx	d5,d0
	add	d3,(a2)+

	cmp	d6,d0
	bhs.b	.ddwq
	dbf	d7,.lep2
	bra.w	.qw
.ddwq
	move.b	AS_LoopFlag(a4),d1
	bne.b	.q
	st	AS_NoLoop(a4)
	bra.w	.tyy
.q
	addq	#1,d7

	btst	#ASLoopF_PingPong,d1
	bne.s	.PingPongLoop
.NormalLoop
	bset	#ASLoopF_Looping,AS_CurrentFPOS+2(a4)

	move.l	AS_RepeatAdr(a4),a0		;loop start
	move.l	a0,AS_CurrentAdr(a4)

	moveq	#0,d1
	move.w	d0,d1				;im aktuellen Rundlauf gespielte Lnge
	add.l	AS_CurrentPos(a4),d1
	sub.l	AS_Samplesize(A4),d1

	move.l	d1,AS_CurrentPos(a4)
	add.l	d1,a0

	move.l	AS_RepeatSize(a4),d6		;loop len
	move.l	d6,AS_SampleSize(a4)
	sub.l	d1,d6				;Len - Current Position
	clr	d0				;reset integer part

	tst.l	AS_Int(a4)		;"Interrupt" bei neuem Sample ?
	beq.s	.noInt
	movem.l	d0-a6,-(sp)		;nur zur Sicherheit
	move.l	AS_Int(A4),a1
	move.l	4.w,a6
	jsr	_LVOCause(a6)
	movem.l	(sp)+,d0-a6		;man weiss ja nie...
.noINT
	dbf	d7,.checkd6	;max. Samplesize is bigger >64k !!
	bra.s	.qw
.PingPongLoop
	btst	#ASLoopF_Looping,AS_CurrentFPOS+2(a4)
	beq.s	.NormalLoop

	bset	#ASLoopF_BackLooping,AS_CurrentFPOS+2(a4)

	move.l	AS_RepeatAdr(a4),a0		;loop start
	move.l	a0,AS_CurrentAdr(a4)

	moveq	#0,d1
	move.w	d0,d1				;im aktuellen Rundlauf gespielte Lnge
	add.l	AS_CurrentPos(a4),d1
	sub.l	AS_Samplesize(A4),d1		;bertrag ber eigentliche aktuelle Lnge

	move.l	AS_Repeatsize(a4),d6
	move.l	d6,AS_Samplesize(a4)
	sub.l	d1,d6
	subq.l	#1,d6
	move.l	d6,AS_CurrentPos(a4)		;aktuelle Position = Repeatsize-1-bertrag
	add.l	d6,a0				;Aktuelle Position
	clr	d0				;reset integer part

	tst.l	AS_Int(a4)		;"Interrupt" bei neuem Sample ?
	beq.s	.noInt_P
	movem.l	d0-a6,-(sp)		;nur zur Sicherheit
	move.l	AS_Int(A4),a1
	move.l	4.w,a6
	jsr	_LVOCause(a6)
	movem.l	(sp)+,d0-a6		;man weiss ja nie...
.noINT_P
	dbf	d7,.Ping_Init
.qw
	moveq	#0,d1
	move	d0,d1
	add.l	AS_CurrentPos(a4),d1
	move.l	d1,AS_CurrentPos(a4)

	swap	d0
	move	d0,AS_CurrentFPOS(a4)	;Fraction Pos

	sub.l	AS_SampleSize(a4),d1
	ble.s	.u

	tst.b	AS_LoopFlag(a4)
	bne.b	.q2
	st	AS_NoLoop(a4)			; sample is not looping
	bra.b	.u

.q2
	bset	#ASLoopF_Looping,AS_CurrentFPOS+2(a4)

	move.l	AS_RepeatSize(a4),d6		;loop len
	move.l	d6,AS_RepeatSize(a4)
	move.l	AS_Repeatadr(a4),a0
	move.l	A0,AS_CurrentAdr(a4)

	move.l	d1,AS_CurrentPos(a4)

	tst.l	AS_Int(a4)		;"Interrupt" bei neuem Sample ?
	beq.s	.noInt1
	movem.l	d0-a6,-(sp)		;nur zur Sicherheit
	move.l	AS_Int(A4),a1
	move.l	4.w,a6
	jsr	_LVOCause(a6)
	movem.l	(sp)+,d0-a6		;man weiss ja nie...
.noINT1
.u
	addq	#1,chans
	rts
.ty
	rts
.tyy
	move	#$80,d0
;	subq	#1,d7
	tst	d7
	bmi.b	.u
.ll3	add	d0,(a2)+
	dbf	d7,.ll3
	bra.b	.u

.Ping_Init
		neg.w	d4		;rckwrts zhlen bei Mixrate < originale Samplerate 
					;in D6 brige Lnge (currentPos = Rest vom aktuellen
					;Wert bis 0)
		move.l	a1,d1
		neg.w	d1
		move.l	d1,a1
.Ping_checkd6
		cmp.l	#$7fff,d6
		bls.s	.Ping_ok
		move.l	#$7fff,d6
.Ping_ok

.Ping_leii
		subq	#8,d7
		blt.s	.Ping_lep

		move.l	a1,d1			;Anzahl zu holender Bytes bei 8 Mixdurchlufen
		add.l	d0,d1			;+ aktuelle Position, wieviele Bytes schon weg sind
		add	d6,d1			;grer als brige Bytes ?
		ble.s	.Ping_lep		;yup

		rept	8
		move.b	(a0,d0),d2
		move.l	d2,a3
		move.b	(a3),d3
		add.l	d4,d0
		subx	d5,d0
		add	d3,(a2)+
		endr

		bra.w	.Ping_leii
.Ping_lep	addq	#8,d7
		beq.w	.Ping_qw
		subq	#1,d7
.Ping_lep2
		move.b	(a0,d0.w),d2
		move.l	d2,a3
		add.l	d4,d0
		move.b	(a3),d3
		subx	d5,d0
		add	d3,(a2)+

		move	d0,d1
		add	d6,d1
		ble.s	.Ping_ddwq

		dbf	d7,.Ping_lep2
		bra.s	.Ping_qw
.Ping_ddwq
;		move.b	AS_LoopFlag(a4),d1
;		bne.b	.q
;		st	AS_NoLoop(a4)
;		bra.w	.ty
;.q

;weil gerade rckwrts gelooped wurde, gehts nun in jedem Fall vorwrts weiter

		addq	#1,d7

		neg.w	d0		;|gespielte Lnge| (fr bertrag)

		bclr	#ASLoopF_BackLooping,AS_CurrentFPOS+2(a4)

		move.l	AS_RepeatAdr(a4),a0		;loop start
		move.l	a0,AS_CurrentAdr(a4)

		moveq	#0,d1
		move.w	d0,d1				;im aktuellen Rundlauf gespielte Lnge
		sub.l	AS_CurrentPos(a4),d1
		move.l	d1,AS_CurrentPos(a4)
		add.l	d1,a0

		move.l	AS_RepeatSize(a4),d6		;loop len
		move.l	d6,AS_SampleSize(a4)
		sub.l	d1,d6				;Len - Current Position
		clr	d0				;reset integer part

		tst.l	AS_Int(a4)		;"Interrupt" bei neuem Sample ?
		beq.s	.Ping_noInt
		movem.l	d0-a6,-(sp)		;nur zur Sicherheit
		move.l	AS_Int(A4),a1
		move.l	4.w,a6
		jsr	_LVOCause(a6)
		movem.l	(sp)+,d0-a6		;man weiss ja nie...
.Ping_noINT
		neg.w	d4		;rckwrts zhlen bei Mixrate < originale Samplerate 
					;in D6 brige Lnge (currentPos = Rest vom aktuellen
					;Wert bis 0)

		move.l	a1,d1
		neg.w	d1
		move.l	d1,a1

		dbf	d7,.checkd6	;max. Samplesize is bigger >64k !!

		swap	d0
		move	d0,AS_CurrentFPOS(a4)	;Fraction Pos
		bra.s	.Ping_U
.Ping_qw
		neg.w	d0		;|gespielte Lnge| (fr bertrag)

		moveq	#0,d1
		move	d0,d1

		swap	d0
		move.w	d0,AS_CurrentFPOS(a4)	;Fraction Pos

		move.l	AS_CurrentPos(a4),d6
		sub.l	d1,d6
		move.l	d6,AS_CurrentPos(a4)
		bgt.s	.Ping_U

		bclr	#ASLoopF_BackLooping,AS_CurrentFPOS+2(a4)

		move.l	AS_RepeatAdr(a4),a0		;loop start
		move.l	a0,AS_CurrentAdr(a4)

		neg.l	d6
		move.l	d6,AS_CurrentPos(A4)

		move.l	AS_RepeatSize(a4),d6		;loop len
		move.l	d6,AS_SampleSize(a4)

		tst.l	AS_Int(a4)		;"Interrupt" bei neuem Sample ?
		beq.s	.Ping_noInt1
		movem.l	d0-a6,-(sp)		;nur zur Sicherheit
		move.l	AS_Int(A4),a1
		move.l	4.w,a6
		jsr	_LVOCause(a6)
		movem.l	(sp)+,d0-a6		;man weiss ja nie...
.Ping_noINT1
.Ping_u
		addq	#1,chans
		rts

;---------------------- fr Stereo 8 Bit & Mono 8 Bit ---------------------
copybufStereo:			;fr 68030-68060, UPS Struktur im Fastmem
	lea	divtabs,a2
	move	chans,d0
	lsl	#2,d0
	move.l	-4(a2,d0),a2

	subq.l	#8,a1
	subq.l	#8,a5
	move	#Samlen/8-1,d7
.ldd3
	move.l	d7,a3

	movem.w	(a0)+,d0/d1/d3/d4/d5/d7		;Routine stark verschachtelt, in 8 Bit Amplifier.2
	move.b	(a2,d0),d2			;nachschauen, dort is sie ordentlich !
	move.b	(a2,d5),d6
	lsl	#8,d2
	move.b	(a2,d1),d2
	lsl	#8,d6
	swap	d2
	move.b	(a2,d7),d6
	move.b	(a2,d3),d2
	swap	d6
	lsl	#8,d2
	move.b	(a2,d4),d2
	addq.l	#8,a1
	addq.l	#8,a5
	movem.w	(a0)+,d0/d1/d3/d4/d5/d7	;2 Register fr D6, 4 Register fr D2

	move.b	(a2,d0),d6
	lsl	#8,d6
	move.b	(a2,d1),d6
	movem.l	d2/d6,(a1)
	movem.l	d2/d6,(a5)

	move.b	(a2,d3),d2
	lsl	#8,d2
	move.b	(a2,d4),d2
	swap	d2
	move.b	(a2,d5),d2
	lsl	#8,d2
	move.b	(a2,d7),d2
	addq.l	#8,a1
	addq.l	#8,a5

	movem.w	(a0)+,d0/d1/d3/d4
	move.b	(a2,d0),d6
	lsl	#8,d6
	move.b	(a2,d1),d6
	swap	d6
	move.b	(a2,d3),d6
	lsl	#8,d6
	move.b	(a2,d4),d6
	movem.l	d2/d6,(a1)
	movem.l	d2/d6,(a5)

	move.l	a3,d7
	dbf	d7,.ldd3
	rts
copybufStereo000:		;fr 68000-68020, UPS Struktur im Chipmem
	lea	divtabs,a2
	move	chans,d0
	lsl	#2,d0
	move.l	-4(a2,d0),a2

	subq.l	#8,a1
	move	#Samlen/8-1,d7
.ldd3
	move.l	d7,a3

	movem.w	(a0)+,d0/d1/d3/d4/d5/d7		;Routine stark verschachtelt, in 8 Bit Amplifier.2
	move.b	(a2,d0),d2			;nachschauen, dort is sie ordentlich !
	move.b	(a2,d5),d6
	lsl	#8,d2
	move.b	(a2,d1),d2
	lsl	#8,d6
	swap	d2
	move.b	(a2,d7),d6
	move.b	(a2,d3),d2
	swap	d6
	lsl	#8,d2
	move.b	(a2,d4),d2
	addq.l	#8,a1
	movem.w	(a0)+,d0/d1/d3/d4/d5/d7	;2 Register fr D6, 4 Register fr D2

	move.b	(a2,d0),d6
	lsl	#8,d6
	move.b	(a2,d1),d6
	movem.l	d2/d6,(a1)

	move.b	(a2,d3),d2
	lsl	#8,d2
	move.b	(a2,d4),d2
	swap	d2
	move.b	(a2,d5),d2
	lsl	#8,d2
	move.b	(a2,d7),d2
	addq.l	#8,a1

	movem.w	(a0)+,d0/d1/d3/d4
	move.b	(a2,d0),d6
	lsl	#8,d6
	move.b	(a2,d1),d6
	swap	d6
	move.b	(a2,d3),d6
	lsl	#8,d6
	move.b	(a2,d4),d6
	movem.l	d2/d6,(a1)

	move.l	a3,d7
	dbf	d7,.ldd3
	rts

;------------------------ fr Surround  8 Bit ---------------------------
;
copybufSurround:
	ifne	benchmark
	move	#$0f0,$dff180
	endc

	lea	divtabs,a2
	move	chans,d0
	lsl	#2,d0
	move.l	-4(a2,d0),a2

	move	prefetch(pc),d7
	lsr	#2,d7

	move.w	#samlen/4-1,d6
	sub.w	d7,d6

	subq.w	#1,d7
	move.w	d7,d0

	push	a3
.pref
	movem.l	(a3)+,d1/d3
	movem.l	d1/d3,(a4)
	movem.l	d1/d3,(a6)
	addq.l	#8,a4
	addq.l	#8,a6
	dbf	d7,.pref

	pop	a3

.ldd3
	movem.w	(a0)+,d1/d3/d4/d5
	move.b	(a2,d1),d2
	lsl	#8,d2
	move.b	(a2,d3),d2
	swap	d2
	move.b	(a2,d4),d2
	lsl	#8,d2
	move.b	(a2,d5),d2

	move.l	d2,(a1)+
	move.l	d2,(a5)+
	not.l	d2
	move.l	d2,(a4)+
	move.l	d2,(a6)+

	movem.w	(a0)+,d1/d3/d4/d5
	move.b	(a2,d1),d2
	lsl	#8,d2
	move.b	(a2,d3),d2
	swap	d2
	move.b	(a2,d4),d2
	lsl	#8,d2
	move.b	(a2,d5),d2

	move.l	d2,(a1)+
	move.l	d2,(a5)+
	not.l	d2
	move.l	d2,(a4)+
	move.l	d2,(a6)+
	dbf	d6,.ldd3

.pref2
	movem.w	(a0)+,d1/d3/d4/d5/d6/d7
	move.b	(a2,d1),d2
	lsl	#8,d2
	move.b	(a2,d3),d2
	swap	d2
	move.b	(a2,d4),d2
	lsl	#8,d2
	move.b	(a2,d5),d2

	move.l	d2,(a1)+
	move.l	d2,(a5)+
	not.l	d2
	move.l	d2,(a3)+

	movem.w	(a0)+,d1/d3
	move.b	(a2,d6),d2
	lsl	#8,d2
	move.b	(a2,d7),d2
	swap	d2
	move.b	(a2,d1),d2
	lsl	#8,d2
	move.b	(a2,d3),d2

	move.l	d2,(a1)+
	move.l	d2,(a5)+
	not.l	d2
	move.l	d2,(a3)+
	dbf	d0,.pref2

	ifne	benchmark
	move	#$0,$dff180
	endc
	rts

copybufSurround000:	;fr 68000-68020, UPS Struktur im Fastmem
	ifne	benchmark
	move	#$0f0,$dff180
	endc

	lea	divtabs,a2
	move	chans,d0
	lsl	#2,d0
	move.l	-4(a2,d0),a2

	move	prefetch(pc),d7
	lsr	#2,d7

	move.w	#samlen/4-1,d6
	sub.w	d7,d6

	subq.w	#1,d7
	move.w	d7,d0

	push	a3
.pref
	movem.l	(a3)+,d1/d3
	movem.l	d1/d3,(a4)
	addq.l	#8,a4
	dbf	d7,.pref

	pop	a3

.ldd3
	movem.w	(a0)+,d1/d3/d4/d5
	move.b	(a2,d1),d2
	lsl	#8,d2
	move.b	(a2,d3),d2
	swap	d2
	move.b	(a2,d4),d2
	lsl	#8,d2
	move.b	(a2,d5),d2

	move.l	d2,(a1)+
	not.l	d2
	move.l	d2,(a4)+

	movem.w	(a0)+,d1/d3/d4/d5
	move.b	(a2,d1),d2
	lsl	#8,d2
	move.b	(a2,d3),d2
	swap	d2
	move.b	(a2,d4),d2
	lsl	#8,d2
	move.b	(a2,d5),d2

	move.l	d2,(a1)+
	not.l	d2
	move.l	d2,(a4)+
	dbf	d6,.ldd3

.pref2
	movem.w	(a0)+,d1/d3/d4/d5/d6/d7
	move.b	(a2,d1),d2
	lsl	#8,d2
	move.b	(a2,d3),d2
	swap	d2
	move.b	(a2,d4),d2
	lsl	#8,d2
	move.b	(a2,d5),d2

	move.l	d2,(a1)+
	not.l	d2
	move.l	d2,(a3)+

	movem.w	(a0)+,d1/d3
	move.b	(a2,d6),d2
	lsl	#8,d2
	move.b	(a2,d7),d2
	swap	d2
	move.b	(a2,d1),d2
	lsl	#8,d2
	move.b	(a2,d3),d2

	move.l	d2,(a1)+
	not.l	d2
	move.l	d2,(a3)+
	dbf	d0,.pref2

	ifne	benchmark
	move	#$0,$dff180
	endc
	rts

	ifne	benchmark
copybufSurroundold
	move	#$f0f,$dff180

	lea	divtabs,a2
	move	chans,d0
	lsl	#2,d0
	move.l	-4(a2,d0),a2

	move	prefetch(pc),d7

	move.w	#samlen-1,d6
	sub.w	d7,d6

	subq.w	#1,d7
	move.w	d7,d0

	lea	(a3),a6
.pref
	move.w	(a6)+,(a4)+
	dbf	d7,.pref

.ldd3
	movem.w	(a0)+,d1/d3
	move.b	(a2,d1),d2
	lsl	#8,d2
	move.b	(a2,d3),d2

	move.w	d2,(a1)+
	not.w	d2
	move.w	d2,(a4)+
	dbf	d6,.ldd3

.pref2
	movem.w	(a0)+,d1/d3
	move.b	(a2,d1),d2
	lsl	#8,d2
	move.b	(a2,d3),d2

	move.w	d2,(a1)+
	not.w	d2
	move.w	d2,(a3)+
	dbf	d0,.pref2

	move	#$0,$dff180
	rts
	endc
;*****************************************************************************
;*                        Daten und Initialisierungen                        *
;*****************************************************************************
dectable:
	dc.l	1,10,100,1000,10000,100000,1000000,10000000,100000000

int:	dc.b	`intuition.library`,0

	ifne	V37Gadtools
gad:	dc.b	`gadtools13.library`,0
	else
gad:	dc.b	`gadtools.library`,0
	endc

dos:	dc.b	`dos.library`,0
graf	dc.b	`graphics.library`,0

NoportMessage:	dc.b	`Cannot find EaglePlayer Port`,0
	even
portname:	dc.b	`EAGLEPLAYERPORT`,0

my_easygadget:	dc.b	`   OK   `,0
my_easygadget2	dc.b	`Retry|Cancel`,0

	even
	Project0WindowTags:
Project0L:
	DC.L	WA_Left,0
Project0T:
	DC.L	WA_Top,0
Project0W:
	DC.L	WA_Width,0
Project0H:
	DC.L	WA_Height,0

	DC.L	WA_IDCMP,IDCMP_Changewindow!IDCMP_RawKey!IDCMP_Menupick!LISTVIEWIDCMP!BUTTONIDCMP!IDCMP_CLOSEWINDOW!IDCMP_REFRESHWINDOW
	DC.L	WA_Flags,WFLG_DRAGBAR!WFLG_DEPTHGADGET!WFLG_CLOSEGADGET!WFLG_SMART_REFRESH

	DC.L	WA_Title,Project0WTitle
	DC.L	WA_ScreenTitle,Project0STitle
	dc.l	wa_newlookmenus,1
	dc.l	wa_autoadjust,1

	dc.l	wa_pubscreen
Pubadr
	dc.l	0
	dc.l	WA_Zoom
	dc.l	ZoomStruct
	DC.L	TAG_DONE,0
ZoomStruct
	dc.w	0,0,150,0

Ahawidth
	dc.l	399
Ahaheight
	dc.l	80

IR:
	DC.L	GT_VisualInfo,$00000000,GTBB_recessed,0
	dc.l	TAG_DONE
MTags0:
	DC.L	GTMN_Newlookmenus,1
	dc.l	TAG_DONE

TopazName:
	DC.B	'topaz.font',0

;--------------------------- spezifische Texte und Strukturen --------------------

MyAnalyzername:		dc.b	`E_8Bit_AMP.1`,0
MyUsername:		dc.b	`8 Bit Amplifier`,0
;MyUsername:		dc.b	`8 Bit Amplifier TEST`,0
myBuggsname:		dc.b	`Buggs of Defect`,0


myinfo		dc.b	`This Amplifier supports`,10
		dc.b	`up to 32 voices in standard`,10
		dc.b	`Amiga 8 Bit mode.`,10,10
		dc.b	`It allows to change the`,10
		dc.b	`stereo bandwidth from mono`,10
		dc.b	`to surround for much better`,10
		dc.b	`sound in critical rooms and`,10
		dc.b	`especially when using head-`,10
		dc.b	`phones. Additionally you`,10
		dc.b	`can use the "pseudo stereo"`,10
		dc.b	`mode for mono samples and`,10
		dc.b	`-modules.`,10
		dc.b	`This program allows to `,10
		dc.b	`change all parameters`,10
		dc.b	`( mixing rate,  surround`,10
		dc.b	`settings, volume boost ...)`,10
		dc.b	`in realtime.`,10,10
		dc.b	`Version `
		ver
		dc.b	` `,10
		dc.b	`Written by Buggs of Defect.`,10
		dc.b	`The mixing routine is based`,10
		dc.b	`on the "PS3M" code written `,10
		dc.b	`and  by Jarno Paananen,all`,10
		dc.b	`optimizations & extensions`,10
		dc.b	` Henryk "Buggs" Richter.`,0

my_easytitle:	dc.b	`8 Bit Amplifier Message`,0

Aboutmessage:	dc.b	`     Eagleplayer 8 Bit 32 voices Amplifier`
		ver
		dc.b	10,10
		dc.b	`             1995 Buggs of DEFECT`,10
		dc.b	`Contact Me At :`,10
		dc.b	`                  Henryk Richter`,10
		dc.b	`             Stephan-Jantzen-Ring  47`,10
		dc.b	`                  18106  Rostock`,10
		dc.b	`                     Germany`,10,10
		dc.b	`             Phone:  +49-0381-1208867`,10
		dc.b	`      EMAIL: tfa652@cks1.rz.uni-rostock.de`,10,10,0

Project0WTitle:
	dc.b	'8 Bit Amplifier',0
Project0STitle:
	DC.B	'8 Bit Surround Amplifier,  DEFECT Softworks',0
	even


Project0GTypes:
    DC.W    LISTVIEW_KIND
    DC.W    INTEGER_KIND
    DC.W    SLIDER_KIND
    DC.W    SLIDER_KIND
    DC.W    TEXT_KIND
    DC.W    TEXT_KIND
    DC.W    SLIDER_KIND
    DC.W    SLIDER_KIND

Project0NGads:
NG_Listview
    DC.W    4,14,301,48
    DC.L    LISTVIEWText,0
    DC.W    GD_LISTVIEW
    DC.L    PLACETEXT_ABOVE,0,0

    DC.W    229,97,68,14
    DC.L    SamplefreqText,0
    DC.W    GD_Samplefreq
    DC.L    0,0,0

    DC.W    12,99,213,10
    DC.L    MixingSliderText,0
    DC.W    GD_MixingSlider
    DC.L    PLACETEXT_ABOVE,0,0

    DC.W    66,72,182,12
    DC.L    VBoostText,0
    DC.W    GD_VBoost
    DC.L    PLACETEXT_ABOVE,0,0

    DC.W    26,71,26,14
    DC.L    VoicesText,0
    DC.W    GD_Voices
    DC.L    PLACETEXT_ABOVE,0,0

	DC.W    257,71,36,13
	DC.L    NullText,0
	DC.W    GD_NumVBoost
	DC.L    PLACETEXT_ABOVE,0,0

	DC.W    14,130,283,9

	DC.L    Gadget60Text,0
	DC.W    GD_Playmode
	DC.L    PLACETEXT_ABOVE,0,0

	DC.W    152,141,145,9
	DC.L    SurlevelText,0
	DC.W    GD_Surlevel
	DC.L    PLACETEXT_LEFT,0,0

myhook					;Filterhook, um zu groe Fonts nicht
					;anzuzeigen
	dcb.b	mln_size,0
	dc.l	my_hook
	dc.l	0
	dc.l	0

Project0GTags:
    DC.L    GTLV_ShowSelected,0
	dc.l	GTLV_CallBack,myhook
    DC.L    TAG_DONE

    DC.L    GTIN_Number,32768
    DC.L    GTIN_MaxChars,5
    DC.L    STRINGA_Justification,GACT_STRINGCENTER
    DC.L    TAG_DONE
    DC.L    GTSL_Min,400
    DC.L    GTSL_Max,5800
    DC.L    GTSL_Level,100
    DC.L    PGA_Freedom,LORIENT_HORIZ
    DC.L    GA_Immediate,1
    DC.L    GA_RelVerify,1
    DC.L    TAG_DONE
    DC.L    GTSL_Min,10
    DC.L    GTSL_Max,100
    DC.L    GTSL_Level,100
    DC.L    PGA_Freedom,LORIENT_HORIZ
    DC.L    GA_Immediate,1
    DC.L    GA_RelVerify,1
    DC.L    TAG_DONE
    DC.L    GTTX_Text,VoicesString
    DC.L    GTTX_Border,1
    DC.L    TAG_DONE
    DC.L    GTTX_Text,NumVBoostString
    DC.L    TAG_DONE
    DC.L    GTSL_Min,-64
    DC.L    GTSL_Max,64
    DC.L    PGA_Freedom,LORIENT_HORIZ
    DC.L    GA_Immediate,1
    DC.L    GA_RelVerify,1
    DC.L    GT_Underscore,'_'
    DC.L    TAG_DONE
    DC.L    PGA_Freedom,LORIENT_HORIZ
    DC.L    GA_Immediate,1
    DC.L    GA_RelVerify,1
    DC.L    GTSL_Min,0
    DC.L    GTSL_Max,Samlen/10
    DC.L    TAG_DONE


NumVBoostString:
    DC.B    '10.2',0

VoicesString:
    DC.B    '16',0

LISTVIEWText:
    DC.B    'Prefs for each number of Voices',0

SamplefreqText:
    DC.B    ' ',0

MixingSliderText:
    DC.B    'Sample mixing frequency',0

VBoostText:
    DC.B    'Volume Boost'
NullText:
    dc.b	` `,0

VoicesText:
    DC.B    'Voices',0

Gadget60Text:
    DC.B    'Mono <------- _Stereo ---> Surround',0

SurlevelText:
    DC.B    'Surround delay',0

	even

Project0NewMenu0:
    DC.B    NM_TITLE,0
    DC.L    Project0MName0
    DC.L    0
    DC.W    0
    DC.L    0,0

	DC.B	NM_ITEM,0
	DC.L	Project0MName91
	DC.L	Project0MComm9
Hiercheck_Mono
	DC.W	CHECKIT!Menutoggle
	DC.L	0,0

	DC.B    NM_ITEM,0
	DC.L    NM_BARLABEL,0
	DC.W    0
	DC.L    0,0

    DC.B    NM_ITEM,0
    DC.L    Project0MName6
    DC.L    Project0MComm6
    DC.W    0
    DC.L    0,0

    DC.B    NM_ITEM,0
    DC.L    Project0MName7
    DC.L    Project0MComm7
    DC.W    0
    DC.L    0,0

    DC.B    NM_ITEM,0
    DC.L    Project0MName8
    DC.L    Project0MComm8
    DC.W    0
    DC.L    0,0

    DC.B    NM_TITLE,0
    DC.L    Project0MName61
    DC.L    0
    DC.W    0
    DC.L    0,0

	DC.B	NM_ITEM,0
	DC.L	Project0MName1
	DC.L	Project0MComm1
Hiercheck
	DC.W	CHECKIT!Menutoggle
	DC.L	0,0

	DC.B    NM_ITEM,0
	DC.L    NM_BARLABEL,0
	DC.W    0
	DC.L    0,0

    DC.B    NM_ITEM,0
    DC.L    Project0MName71
    DC.L    0
    DC.W    0
    DC.L    0,0

    DC.B    NM_ITEM,0
    DC.L    Project0MName81
    DC.L    0
    DC.W    0
    DC.L    0,0

    DC.B    NM_END,0
    DC.L    0,0
    DC.W    0
    DC.L    0,0

Project0MName0:		DC.B    'Project',0
Project0MName1		dc.b	'Global',0
Project0MComm1		dc.b	'G',0
Project0MName6:		DC.B    'About',0
Project0MComm6:		DC.B    'A',0
Project0MName7:		DC.B    'Hide',0
Project0MComm7:		DC.B    'H',0
Project0MName8:		DC.B    'Quit',0
Project0MComm8:		DC.B    'Q',0
Project0MComm9:		DC.B    'M',0

Project0MName61:
    DC.B    'Settings',0

Project0MName71:
    DC.B    'Reset to Defaults',0

Project0MName81:
    DC.B    'Save Settings',0

Project0MName91:
    DC.B    'Mono Modules Mode',0

	even
TD:
    DC.L    TAG_DONE

;--------------------------------------------------------------------------------------------

	*------- Activate ------*
EP_Menu:	dc.l	EPM_Show		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$5B
		dc.l	0
		dc.l	.ActivateIText
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.ActivateIText:	dc.b	0,3
		ds.w	2
		dc.w	1
		dc.l	0			*Topaz80
		dc.l	0			*Active.MSG (filled by EP)
		dc.l	0
		dc.w	EPNr_MainWindow	*EPNr_Engine
		dc.w	LNr_Active

	*------- Show-Window ------*
EPM_Show	dc.l	0 EPM_BarLabel		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$5B
		dc.l	0
		dc.l	.ShowIText
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.ShowIText:	dc.b	0,3
		ds.w	2
		dc.w	1
		dc.l	0			*Topaz80
		dc.l	0			*Active.MSG (filled by EP)
		dc.l	0
		dc.w	EPNr_EngineShowState
		dc.w	LNr_Show2

;----------------- hier nun die Daten fr den Mixing Player ----------------
LastBuffer	dc.l	0

OLDINT0:	dc.l	0
OLDINT1:	dc.l	0
OLDINT2:	dc.l	0
OLDINT3:	dc.l	0

audiorate	dc.l	3546895		;fr PAL
mrate		dc.l	0
mixingperiod	dc.l	0
clock		dc.l	0

Int_loopStruct
	dc.l	0
	dc.l	0
	dc.b	2
	dc.b	32
	dc.l	INT_Name1		;Name
	dc.l	0
	dc.l	Domix			;Interrupt Routine

Aud0Interrupt:
	dc.l	0
	dc.l	0
	dc.b	2
	dc.b	127
	dc.l	INT_Name1		;Name
	dc.l	0
	dc.l	INT_Aud			;Interrupt Routine

INT_Name1	dc.b	`Mixingroutine Audio Interrupt`,0

myAudioStruct	dc.l	0
numStructs	dc.w	0
numleft		dc.w	0
numright	dc.w	0
divtabs:	ds.l	16
LastBoost:	dc.w	0
maxchan		dc.w	0
chans		dc.w	0
modenr		dc.w	0

	;diese hier zusammen lassen
buffer0:	dc.l	0
buffer1:	dc.l	0
buffer2:	dc.l	0
buffer3:	dc.l	0
cbufad		dc.l	copybufStereo
	;---------------------------
SpecialBuffer1	dc.l	0
SpecialBuffer2	dc.l	0
mixad1		dc.l	mix
mixad2		dc.l	mix2	;mix2

Vtabaddr	dc.l	0
usedmode	dc.l	0
mydivtab	dc.l	0
mydivtabsize	dc.l	0
vtab:		dc.l	0
vtabsize:	dc.l	0
effectvol	dc.w	0
onplay		dc.b	0
waitstart	dc.b	0
prefetch	dc.w	0
newmixingperiod	dc.l	0
tmpvol		dc.l	0
tmpvol2		dc.w	0
calcvol		ds.w	4
fformat		dc.w	0
playmixrate	dc.l	0
UPSBuffer0	dc.l	0
UPSBuffer1	dc.l	0
UPSBuffer2	dc.l	0
UPSBuffer3	dc.l	0

;divtab2
;a set 16
;	rept	16
;		ds.b	256*a
;a set a-1
;	endr
;Vtab		ds.b	66*256			; Volume tab size for 14 Bit
;						; for 8 Bit only  of this needed

;*********** Leertabellen (spter im BSS-Hunk) ***********************
		section	1,BSS_p
		rsreset
datas:
RealNumGadgets	rs.w	1
MC68030on	rs.w	1
MyVariable	rs.l	1
Attr		rs.l	2
msgport		rs.l	1
intsave:	rs.l	1
grafsave	rs.l	1
gadsave:	rs.l	1
_dos		rs.l	1
Port:		rs.l	1
Jumpadr		rs.l	1
Menuadr:	rs.l	1
mypubscreen:	rs.l	1	;aktueller Publicscreen
fonth:		rs.l	1	;Fonthhe
;fontatt:	rs.l	1	;Fontattr Strukturadresse (entweder die des
				;Screens oder die eigene,wenn Screenfont zu
				;gro)
vi:		rs.l	1	;Visualinfo

mytags:		rs.l	10*2
mycontextgad:	rs.b	gg_sizeof	;CreateContext() braucht Zeiger auf
					;leere Gadgetstruktur !?

mygad:		rs.b	gng_sizeof	;Platz fr New Gadget Struktur


Project0Gadgets:	rs.l	21
Gadgetadrs=Project0Gadgets

BufNewGad:		rs.w	4
			rs.l	2
			rs.w	1
			rs.l	3

myhoehe2:	rs.w	1
myhoehe1:	equ	myhoehe2
winwidth:	rs.w	1

Project0GList:	rs.l	1
Project0Menus:	rs.l	1
Winhandle	rs.l	1
Font:		rs.l	1
FontX:		rs.w	1
FontY:		rs.w	1
OffX:		rs.w	1
OffY:		rs.w	1
		rs.w	2

MY_Easystruct:	rs.l	1	;EASY-Request
		rs.l	1
		rs.l	1
		rs.l	1
		rs.l	1
temp1		rs.l	128
temp2		rs.l	128
temp:		rs.l	1

refreshflag	rs.b	1
counter		rs.b	1		;Frei
topazused	rs.b	1
modeid		rs.b	1

;an_structadr	rs.l	1
Mytask		rs.l	1
MySignal	rs.l	1
immernull	rs.l	1
myobject	rs.l	1
merkpos		rs.l	1
currpos		rs.l	1
visible		rs.l	1
myplayertaglist	rs.l	1
maxtextwidth	rs.w	1
maxvisible	rs.w	1
SaveString	rs.l	1
myfontatt:	rs.l	1
		rs.w	2

MsgPort1:	rs.b	mp_size	;extra Messageport

micros		rs.l	1
seconds		rs.l	1
merk_seconds	rs.l	1
lasttime	rs.l	1
messagesent	rs.b	1
messagesent2	rs.b	1
savemodnr	rs.l	1
word7		rs.w	1	;Wort fr Absturz bei Modifikation
counter2	rs.w	1
onsysfont	rs.b	1
exg		rs.b	1
onglobal	rs.b	1
		rs.b	1
MyRastport	rs.b	rp_sizeof
fontadr		rs.l	1
onmixingslider	rs.b	1
onvboostslider	rs.b	1
onPlaymodeslider	rs.b	1
onSurlevslider		rs.b	1

NumVoc		rs.l	1	;"12"
numboo		rs.l	1	;"10.1 "
		rs.w	1

SelectedL:	rs.w	1		;die zwei gehren zusammen
SelectedW:	rs.w	1		;-------------------------
Currentnumvoc	rs.w	1

List:		rs.b	lh_size
Nodes:		rs.b	ML_Sizeof*32		;max. 32 voices

ConfigDatas	rs.b	0

Prefslist	rs.w	5*32		;mixingrate.l
					;Vboost.w
					;Effect.w  StereoBasisbreite.b
					;          Surround Level.b
					;
					;Flags.w (Bit0=disable)

ConfigDatasEND	rs.b	0

	ifne	debug
saveusernr	rs.w	1
	endc
DatasLen:	rs.w	0
		ds.b	DatasLen

	section	2,bss_c
;-------------- Puffer fr die DMA simulierung -----------------
Buffer0a:	ds.w	SamLen*NumChipBuffers
		ds.w	2

Buffer1a:	ds.w	SamLen*NumChipBuffers
		ds.w	2

Buffer2a:	ds.w	SamLen*NumChipBuffers
		ds.w	2

Buffer3a:	ds.w	SamLen*NumChipBuffers
		ds.w	2
EndBuffer

	section	3,bss_p

MyUPSStruct	ds.b	UPS_Sizeof

StartBSSBuffer
TempBuffer	ds.b	samlen*2*2+2
TempBuffer2	ds.b	samlen*2*2+2

TBufLeft	ds.b	samlen*2
TBufRight	ds.b	samlen*2

UPSBuffer0a:	ds.w	SamLen*NumChipBuffers	;selbe Lngen und Offsets wie Buffer0a...3a
		ds.w	2
UPSBuffer1a:	ds.w	SamLen*NumChipBuffers
		ds.w	2
UPSBuffer2a:	ds.w	SamLen*NumChipBuffers
		ds.w	2
UPSBuffer3a:	ds.w	SamLen*NumChipBuffers
Security	ds.b	20

EndBSSBuffer
Extra_AS	ds.b	AS_Sizeof*32
;bla		ds.b	200000
	end
